﻿var themeEditor = {
    container: $("#themeContainer"),
    context: $("#themeEditor"),
    displayZone: null,
    previewZone: null,
    editorZone: null,
    activeClass: null,
    page: null,
    configuration: null,
    questions: [],
    defaultVoxcoImage: "../../../Content/Images/VoxcoFav.gif",

    editorItemValue: "",            // The value of the last update for the editor
    backgroundColor: null,
    isReadOnly: false,
    displayBlockThemeIsOverridden: null,

    themeId: 0,
    isModule: false,
    projectId: 0,
    moduleId: 0,
    themeName: "",
    templateId: null,
    templateSource: null,
    questionnaireId: 0,

    historicalSettings: {},         // Tracking list of changes since last post-back, used when loading a new block
    settings: {},
    values: {},
    translatables: {},
    savedTranslatables: {},

    questionNameVisible: true,
    questionTextVisible: true,

    checkboxType: null,
    checkBoxImage: "",
    checkBoxSelectedImage: "",

    radioButtonType: null,
    radioButtonImage: "",
    radioButtonSelectedImage: "",

    gridHighlighedAxisColor: "",
    gridSelectedAxisColor: "",
    choiceHoverColor: "",

    borderColorAllTriggered: false,
    borderStyleAllTriggered: false,

    buttonBackPosition: "none", // none == center 
    buttonNextPosition: "none",
    buttonQuitPosition: "none",
    backButtonHoverImage: "",
    nextButtonHoverImage: "",
    quitButtonHoverImage: "",
    questionClearButtonHoverImage: "",

    filterMinWidth: "",
    filterWidth: ""
};

$.fn.uislider = $.fn.slider;
$.fn.hasScrollBar = function (direction) { // vertical or horizontal
    if (direction == 'vertical') {
        return this.get(0) ? this.get(0).offsetHeight < this.get(0).scrollHeight : false;
    }
    else if (direction == 'horizontal') {
        return this.get(0) ? this.get(0).offsetWidth > this.get(0).scrollWidth : false;
    }
    return false;
}

jQuery.fn.scrollTo = function (elem) {
    $(this).scrollTop($(this).scrollTop() - $(this).offset().top + $(elem).offset().top);
    return this;
};

$(document).ready(function () {
    if (themeEditor.context.length > 0)
    {
        themeEditor.initialize();
        themeEditor.bindEvents();
    }
});

themeEditor.reInitializeEditor = function () {
    themeEditor.container = $("#themeContainer");
    themeEditor.context = $("#themeEditor");

    if (themeEditor.context.length > 0)
    {
        themeEditor.resetPageModification();
        themeEditor.initialize();
    }
};

themeEditor.initialize = function () {
    // Acuity
    themeEditor.displayBlockThemeIsOverridden = $("#DisplayBlockThemeOverridden", themeEditor.context).val();

    if (typeof themeEditor.displayBlockThemeIsOverridden !== "undefined")
        themeEditor.displayBlockThemeIsOverridden = themeEditor.displayBlockThemeIsOverridden.toLowerCase() == "true";

    // NVW
    themeEditor.isModule = $("#IsModule", themeEditor.context).val() == "true";
    themeEditor.projectId = $("#ProjectId", themeEditor.context).val() || 0;
    themeEditor.moduleId = $("#ModuleId", themeEditor.context).val() || 0;
    themeEditor.questionnaireId = $("#QuestionnaireId", themeEditor.context).val() || 0;
    // end NVW

    themeEditor.themeId = $("#ThemeId", themeEditor.container).val() || 0;
    themeEditor.configuration = JSON.parse($("#Configuration", themeEditor.container).val());

    themeEditor.questionNameVisible = $("#QuestionNameVisible", themeEditor.container).val().toLowerCase() == "true";
    themeEditor.questionTextVisible = $("#QuestionTextVisible", themeEditor.container).val().toLowerCase() == "true";

    themeEditor.checkboxType = $("#CheckBoxType", themeEditor.container).val();
    themeEditor.checkBoxImage = $("#CheckBoxDefaultImage", themeEditor.container).val();
    themeEditor.checkBoxSelectedImage = $("#CheckBoxSelectedImage", themeEditor.container).val();

    themeEditor.radioButtonType = $("#RadioButtonType", themeEditor.container).val();
    themeEditor.radioButtonImage = $("#RadioButtonDefaultImage", themeEditor.container).val();
    themeEditor.radioButtonSelectedImage = $("#RadioButtonSelectedImage", themeEditor.container).val();

    themeEditor.gridSelectedAxisColor = $("#GridSelectedAxesColor", themeEditor.container).val();
    themeEditor.gridHighlighedAxisColor = $("#GridHighlightedAxesColor", themeEditor.container).val();

    themeEditor.backButtonHoverImage = $("#BackHoverImage", themeEditor.container).val();
    themeEditor.nextButtonHoverImage = $("#NextHoverImage", themeEditor.container).val();
    themeEditor.quitButtonHoverImage = $("#QuitHoverImage", themeEditor.container).val();

    themeEditor.choiceHoverColor = $("#ChoiceHoverColor", themeEditor.container).val();
    themeEditor.tooltipsVisible = $("#TooltipsVisible", themeEditor.container).val().toLowerCase() == "true";

    themeEditor.displayZone = $(".v-displayElementsControl", themeEditor.container);
    themeEditor.previewZone = $("#previewZone", themeEditor.container);
    themeEditor.editorZone = $("#editorZone", themeEditor.container);
    themeEditor.isReadOnly = ($('.v-questionnaireIsReadOnly', themeEditor.container).val() == "1");

    var pathName = window.location.pathname;
    themeEditor.page = pathName.substring(0, pathName.indexOf('/TemplateEditor') +1);
    themeEditor.themeName = $(".v-leftPanel .title label", themeEditor.container).html();

    $(".starRating", themeEditor.previewZone).starRating();

    themeEditor.setGeneralDropdownChangeEvent();
    themeEditor.applyBorderEvents();
    themeEditor.setNavigationButtonChange();
    themeEditor.setElementDisplayLocationChange();

    themeEditor.setFontEvents();
    themeEditor.setBackgroundEvents();
    themeEditor.setDimensionEvents();
    themeEditor.setProgressBarEvents();
    themeEditor.setSeparatorEvents();
    themeEditor.setFrameEvents();
    themeEditor.setLanguageSelectorEvents();
    themeEditor.setNavigationBarEvents();

    themeEditor.setDisplayEvents();
    themeEditor.setPageEvents();

    themeEditor.initializeCurrentBlockQuestions();
    themeEditor.setPreview();
    themeEditor.applySecurity();
    themeEditor.setPreviewEvents();
    setTimeout(function () { InitLibraryBrowser(themeEditor.container, themeEditor.page, 0); }, 100);

    themeEditor.setEditItemEvent();
    themeEditor.setCancelEvent();

    themeEditor.initializeSection(themeEditor.editorZone);
    themeEditor.setModuleDisplay(themeEditor.container);

    themeEditor.initializePreviewZoom();
    themeEditor.initializeCustomizeDragAndResize(true);

    themeEditor.loadCustomizeTemplateSelection();
    $(".h-saveTemplateSelection", themeEditor.context).css("display", "none");

    themeEditor.adjustNumericRankingTextWidth();
    themeEditor.setButtonsPositionValues();
    themeEditor.setFilterWidthHelpers();

    $("#items-list .inner").mCustomScrollbar({ theme: "dark-2", scrollInertia: 0 });
}

themeEditor.bindEvents = function () {
    // These events need to be binded only once, otherwise multiple triggers will be fired.
    // Even on a second initialize, these should not be replaced since they are outside the editor
    themeEditor.setEditBlockEvent();
    themeEditor.setEditQuestionEvent();
    themeEditor.setSaveThemeEvent();
    themeEditor.setApplyTemplateEvent();
    themeEditor.setTemplatesClickEvent();
    themeEditor.setSaveTemplateSelectionEvent();
    themeEditor.setCancelCustomizationSelectionEvent();
    themeEditor.setSaveToLibraryEvent();
    themeEditor.setEnableBacklink();

    if (themeEditor.isModule)
        themeEditor.setResetAppearanceEvent();
    else
        themeEditor.setUseMobilePageHeaderFooterEvent();
}

themeEditor.setFilterWidthHelpers = function (customize) {
    // get title filter width for manipilation of resizing
    var questionWidth = $('.v-mainPanel .title', themeEditor.container).find(".v-questions-filter").width();
    var blockWidth = $('.v-mainPanel .title', themeEditor.container).find(".v-block-filter").width();
    themeEditor.filterMinWidth = questionWidth > blockWidth ? questionWidth : blockWidth;
    themeEditor.filterWidth = $('.v-mainPanel .title .filter', themeEditor.container).width();
}

themeEditor.setButtonsPositionValues = function () {
    if (themeEditor.isModule) {
        themeEditor.buttonBackPosition = "none";
        themeEditor.buttonNextPosition = "none";
        themeEditor.buttonQuitPosition = "none";

        $(".navigationBackButton", themeEditor.previewZone).css("float", "none");
        $(".navigationNextButton", themeEditor.previewZone).css("float", "none");
        $(".navigationQuitButton", themeEditor.previewZone).css("float", "none");
        $(".navigationBar", themeEditor.previewZone).css("float", "none");
        $(".navigationBar", themeEditor.previewZone).css("text-align", "center");
        $(".navigationBar", themeEditor.previewZone).css("width", "100%");
    }
    else {
        var navigationBarTextAlign = $(".navigationBar", themeEditor.previewZone).css("text-align");
        var backButtonFloat = $(".navigationBackButton", themeEditor.previewZone).css("float");
        var nextButtonFloat = $(".navigationNextButton", themeEditor.previewZone).css("float");
        var quitButtonFloat = $(".navigationQuitButton", themeEditor.previewZone).css("float");

        if (navigationBarTextAlign == "right") {
            if (backButtonFloat == "left")
                themeEditor.buttonBackPosition = "none";
            else
                themeEditor.buttonBackPosition = "right";

            if (nextButtonFloat == "left")
                themeEditor.buttonNextPosition = "none";
            else
                themeEditor.buttonNextPosition = "right";

            if (quitButtonFloat == "left")
                themeEditor.buttonQuitPosition = "none";
            else
                themeEditor.buttonQuitPosition = "right";
        }
        else {
            themeEditor.buttonBackPosition = backButtonFloat;
            themeEditor.buttonNextPosition = nextButtonFloat;
            themeEditor.buttonQuitPosition = quitButtonFloat;
        }
    }
}

themeEditor.initializeCustomizeDragAndResize = function (customize) {
    var themeContainer = $("#themeContainer");
    var mainPanel = $('.v-mainPanel', themeContainer);
    var dragging = false;
    var leftPanel = customize ? $('.v-leftPanel') : $(".v-libraryBrowserPanel .v-templateBrowser", themeEditor.container);

    $('.dragable', themeContainer).on("mousedown", function (e) {
        e.preventDefault();
        dragging = true;
        var main = $('.v-mainPanel');

        $(document).on("mousemove", function (e) {
            var percentage = (e.pageX / window.innerWidth) * 100;
            var mainPercentage = 100 - percentage;
            var maxdragLeft = window.innerWidth * (((percentage - 2) + 0.5) / 100);
            var maxdragRight = window.innerWidth * (mainPercentage / 100);

            if (maxdragLeft > 600 && maxdragRight > 600)
            {
                leftPanel.css("width", ((percentage - 2) + 0.5) + "%");
                $('.v-mainPanel').css("width", mainPercentage + "%");
            }
        });

    });

    $(document).on("mouseup", function (e) {
        if (dragging)
        {
            var percentage = (e.pageX / window.innerWidth) * 100;
            var mainPercentage = 100 - percentage;
            var maxdragLeft = window.innerWidth * (((percentage - 2) + 0.5) / 100);
            var maxdragRight = window.innerWidth * (mainPercentage / 100);

            if (maxdragLeft > 600 && maxdragRight > 600)
            {
                leftPanel.css("width", ((percentage - 2) + 0.5) + "%");
                $('.v-mainPanel').css("width", mainPercentage + "%");
            }

            $(document).off('mousemove');
            dragging = false;
        }
    });
}

themeEditor.initializePreviewZoom = function () {
    var currFFZoom = 1;
    var currIEZoom = 100;
    var themeContainer = $("#themeContainer");
    var mainPanel = $('.v-mainPanel', themeContainer);
    $('.title zoom', mainPanel).html("100%");

    $('.v-mainPanel .title .zoom #In').on('click', function () {
        if (navigator.userAgent.indexOf('Firefox') != -1 && parseFloat(navigator.userAgent.substring(navigator.userAgent.indexOf('Firefox') + 8)) >= 3.6) {//Firefox
            var step = 0.05;
            currFFZoom += step;

            var perc = (currFFZoom * 100).toFixed(0) + "%";
            $('.preview-zone-container', mainPanel).css('MozTransform', 'scale(' + currFFZoom + ')');
            $('.title .zoom .zoomValue', mainPanel).html(perc);
        }
        else {
            var step = 2;
            currIEZoom += step;
            var perc = currIEZoom + "%";
            $('.preview-zone-container', mainPanel).css('zoom', ' ' + currIEZoom + '%');
            $('.title .zoom .zoomValue', mainPanel).html(perc);
        }
        $('.preview-zone-container', mainPanel).css('transform-origin', '0px 0px 0px');
        $('.preview-zone-container', mainPanel).css('position', 'relative');
    });

    $('.v-mainPanel .title .zoom #Out').on('click', function () {
        if ((currFFZoom * 100).toFixed(0) > 0 && currIEZoom > 0) {
            if (navigator.userAgent.indexOf('Firefox') != -1 && parseFloat(navigator.userAgent.substring(navigator.userAgent.indexOf('Firefox') + 8)) >= 3.6) {//Firefox
                var step = 0.05;
                currFFZoom -= step;

                if (currFFZoom < 0)
                    currFFZoom = 0;

                var perc = (currFFZoom * 100).toFixed(0) + "%";
                $('.preview-zone-container', mainPanel).css('MozTransform', 'scale(' + currFFZoom + ')');
                $('.title .zoom .zoomValue', mainPanel).html(perc);
            }
            else {
                var step = 2;
                currIEZoom -= step;
                $('.preview-zone-container', mainPanel).css('zoom', ' ' + currIEZoom + '%');
                var perc = currIEZoom + "%";
                $('.title .zoom .zoomValue', mainPanel).html(perc);
            }

            $('.preview-zone-container', mainPanel).css('transform-origin', '0px 0px 0px');
            $('.preview-zone-container', mainPanel).css('position', 'relative');
        }
    });
}

themeEditor.separatorPreviewChange = function () {
    $(".separator_top", themeEditor.previewZone).remove();
    $(".separator_bottom", themeEditor.previewZone).remove();

    var copy = $("#separator_template", themeEditor.previewZone).clone().removeClass("hidden").removeAttr("id");
    var loc = copy.attr("data-type");

    if (loc == "TopChoice" || loc == "Both")
        $(".questionContainer .choiceList", themeEditor.previewZone).prepend(copy.show().addClass("separator_top"));

    if (loc == "BottomChoice" || loc == "Both")
        $(".questionContainer .choiceList", themeEditor.previewZone).append(copy.show().addClass("separator_top"));
}

themeEditor.setModuleDisplay = function (context) {
    if (!themeEditor.isModule) {
        $(".v-moduleExcluded", context).show();
        $(".v-moduleSpecific", context).remove();
    }
    else {
        $(".v-moduleExcluded", context).remove();
        $(".v-moduleSpecific", context).show();

        $(".v-altTitle", context).each(function () {
            $(this).text($(this).attr("data-alt-label"));
        });

        $(".h-progressBarQuestionSetting", context).a4autocomplete({
            ajaxAction: a4.getAction("GetVariablesForAutoComplete", "Home", "Project"),
            ajaxParams: { questionnaireId: themeEditor.questionnaireId, projectId: themeEditor.projectId },
            valueProperty: "Name",
            labelProperty: "Alias",
            multipleSelection: false,
            select: function (event, data) {
                themeEditor.saveThemeValue($(event.target).attr("data-name"), data.item.Name);
            }
        });

        themeEditor.separatorPreviewChange();

        var grhw = $("#GridRowHeaderCSS .gridRowHeader").css("width");
        $(".grid tr th:first", themeEditor.previewZone).css("min-width", grhw);
    }
}

themeEditor.pageModification = function () {
    $(".v-changeMade").val("changed");
}

themeEditor.resetPageModification = function () {
    $(".v-changeMade").val("");
}

themeEditor.setCancelEvent = function () {
    $(".h-cancelButton", themeEditor.container).on("click", function () {
        themeEditor.resetPageModification();
    });
}

themeEditor.saveSetting = function (editItem, property, value) {
    var item = themeEditor.settings[editItem];

    if (typeof item == "undefined") {
        themeEditor.settings[editItem] = {};
        themeEditor.historicalSettings[editItem] = {};
    }

    themeEditor.settings[editItem][property] = value;
    themeEditor.historicalSettings[editItem][property] = value;
    themeEditor.pageModification();
}

themeEditor.saveThemeValue = function (property, value) {
    themeEditor.values[property] = value;
    themeEditor.pageModification();
}

themeEditor.saveTranslatableValue = function (property, value) {
    themeEditor.translatables[property] = value;
    themeEditor.pageModification();
}

themeEditor.applySelectedTemplateToPreview = function () {
    if (themeEditor.templateId != null && themeEditor.templateId > 0 && themeEditor.templateSource != null) {
        // change the theme title name
        $('.v-leftPanel .title label', themeContainer).html(themeEditor.themeName);

        // Get last preview html from template browser
        var templateBrowserPreviewZone = $("#templatePanel .v-contentFrame .v-content", themeEditor.container);
        var previewHtml = templateBrowserPreviewZone.html();

        // Refresh preview
        var questions = $(".questionBlock", themeEditor.previewZone).html();
        themeEditor.previewZone.html.empty;
        themeEditor.previewZone.html(previewHtml);
        $(".questionBlock", themeEditor.previewZone).html(questions);

        // Reload display elements control (general settings)
        themeEditor.loadDisplayControl(themeEditor.themeId);

        // Unload zones that have been loaded 
        $(".v-editThemeElement", themeEditor.editorZone).html("");

        // Reload current editor zone item
        themeEditor.selectItemChange($(".v-selectItem.inEdit", themeEditor.container), true);

        themeEditor.setPreview();
    }
}

themeEditor.loadDisplayControl = function (themeId) {
    a4.callServerMethod(a4.getSurveyAction("GetDisplayControl", "LookAndFeel"), { themeId: themeId },
		function (result) {
		    themeEditor.displayZone.html(result);
		    themeEditor.initializeSection(themeEditor.displayZone);  // Set active class and items			            
		    themeEditor.applySecurity();
		    themeEditor.refreshTooltips();

		    $("input", themeEditor.displayZone).on("keypress", function (e) { return (e.keyCode != 13); });
		},
		function (error) { }
    );
}

themeEditor.completeSaveTheme = function () {
    for (var _text in themeEditor.translatables) {
        themeEditor.savedTranslatables[_text] = themeEditor.translatables[_text];
    }

    themeEditor.values = {};
    themeEditor.settings = {};
    themeEditor.translatables = {};
    themeEditor.templateId = null;
    themeEditor.templateSource = null;

    themeEditor.loadCustomizeTemplateSelection();
}

themeEditor.saveModifiedSetting = function (property, previewClass, value) {
    var cssClass = themeEditor.getThemeElementType(previewClass);
    themeEditor.saveSetting(cssClass, property, value);
}

themeEditor.setSaveThemeEvent = function () {
    themeEditor.context.on("click", ".h-saveTheme", function () {
        themeEditor.saveTheme(true, true);
    });
}

themeEditor.setUseMobilePageHeaderFooterEvent = function () {
    themeEditor.context.on("change", ".v-useHeaderFooterMobile", function () {
        var isChecked = $(this).is(":checked");
        var editSubSection = $(this).closest(".v-editThemeElement");
        var themeElement = $(this).hasClass("v-useHeaderMobile") ? "UsePageHeaderMobile" : "UsePageFooterMobile";

        $(".v-headerFooterMobile", editSubSection).toggle(isChecked);
        themeEditor.saveThemeValue(themeElement, isChecked.toString());
    });
}

themeEditor.setEnableBacklink = function () {
    themeEditor.context.on("change", ".v-enableBacklink", function () {
        var isChecked = $(this).is(":checked");
        var backlinkPreview = $(".backlink-container", themeEditor.previewZone);
        if (isChecked) {
            backlinkPreview.show();
        }
        else {
            backlinkPreview.hide();
        }
        themeEditor.saveThemeValue("EnableBacklink", isChecked.toString());
    });
}

themeEditor.saveTheme = function (updateThemeNameUi, setCustomized) {
    themeEditor.resetPageModification();
    var args = {};
    var action = null;

    if (themeEditor.projectId > 0 && themeEditor.moduleId > 0)
    {
        action = a4.getAction("SaveAppearance", "Modules", "Project")
        args = {
            projectId: themeEditor.projectId,
            moduleId: themeEditor.moduleId,
            themeValues: themeEditor.values,
            properties: themeEditor.settings,
            translatableTexts: themeEditor.translatables,
            useTemplateId: themeEditor.templateId
        };
    }
    else
    {
        action = a4.getSurveyAction("SaveTheme", "LookAndFeel");
        args = {
            themeId: themeEditor.themeId,
            themeValues: themeEditor.values,
            properties: themeEditor.settings,
            translatableTexts: themeEditor.translatables,
            useTemplateId: themeEditor.templateId || 0,
            templateSource: themeEditor.templateSource,
            setCustomized: setCustomized
        };
    }

    if (_.size(args.properties) == 0)
        args.properties = null;

    if (_.size(args.themeValues) == 0)
        args.themeValues = null;

    if (_.size(args.translatableTexts) == 0)
        args.translatableTexts = null;

    a4.callServerMethod(action, args,
        function (result) {
            a4.showSuccessMessage(themeEditor.resources.SavedChangeSuccess, 2000);

            themeEditor.themeName = result;
            themeEditor.applySelectedTemplateToPreview();
            themeEditor.completeSaveTheme();

            $('html, body').animate({
                scrollTop: 0
            }, 400, "swing", function () {});

            if (themeEditor.themeId != 0)
            {
                if (typeof surveyMenu != 'undefined')
                    surveyMenu.refresh();
                else if (a4.parent().surveyMenu)
                    a4.parent().surveyMenu.refresh();
            }

            // clear selected scheme in modules of project
            if (themeEditor.isModule)
            {
                if (typeof schemes != "undefined")
                    schemes.clearScheme(true);
            }
        }, null, { blockElement: $(".v-libraryBrowserPanel", themeEditor.container) }
    );
}

themeEditor.setResetAppearanceEvent = function () {
    themeEditor.context.on("click", ".v-resetAppearance", function () {
        var moduleId = parseInt(themeEditor.moduleId, 10);
        var projectId = parseInt(themeEditor.projectId, 10);

        if (moduleId > 0 && projectId > 0) {
            var params = {
                projectId: projectId,
                moduleId: moduleId,
                schemeId: 0
            }

            modalDialog.showConfirmDialog(confirmResetAppearanceResources, function () {
                a4.callServerMethod(a4.getAction("GetAppearanceScheme", "Modules", "Project"), params,
                function (result) {
                    if (result.scheme) {
                        $(".h-themeEditorContent", themeEditor.context).html(result.scheme);
                        themeEditor.templateId = 0;
                        themeEditor.reInitializeEditor();
                    }
                });
            }, 250, 500, true);
        }
    });
}

themeEditor.getEventPreviewClass = function (element, eventType, cssProperty) {
    var cssClass = themeEditor.activeClass;
    var elementType = themeEditor.activeClass;

    if (elementType == "progressBar" && eventType != "font")
    {
        cssClass = "progressBarBackground";
        
        if (typeof cssProperty !== "undefined")
        {
            if (cssProperty == "backgroundRepeat" || cssProperty == "position" || cssProperty == "floatAlign")
                cssClass = "progressBarBar";

            else if (cssProperty == "verticalAlign")
                cssClass = "progressBarSideContainer";
        }
    }
    else if (elementType == "questionBackground" && cssProperty == "paddingSide")
    {
        cssClass = "questionContent";
    }
    else if (elementType == "grid")
    {
        if (element.closest(".v-gridColumnSettings").length > 0)
            cssClass = "gridColumnHeader";

        else if (element.closest(".v-gridRowSettings").length > 0)
            cssClass = "gridRowHeader";

        else if (cssProperty == "borderCollapse" || cssProperty == "border-spacing")
            cssClass = "grid";

        else
            cssClass = "gridItem";
    }
    else if (elementType == "lookupTable")
    {
        if (element.closest(".v-gridColumnSettings").length > 0)
            cssClass = "lookupTableColumnHeader";
        else
            cssClass = "lookupTableItem";
    }
    else if (elementType == "selectedImageChoice" && element.closest(".v-imageSettings").length > 0)
    {
        cssClass = "choiceImage";
    }
    else if (elementType == "selectedImageArea" && element.closest(".v-imageSettings").length > 0)
    {
        cssClass = "imageMapImage";
    }
    else if ((elementType == "selectedImageChoice" || elementType == "selectedImageArea") && element.closest(".v-highlightedSettings").length > 0)
    {
        cssClass = elementType.replace("selected", "highlighted");
    }
    else if (elementType == "pageSetup")
    {
        if (element.closest(".v-contentPosition").length > 0)
            cssClass = "pageContentContainer";

        else if (typeof cssProperty != "undefined" && cssProperty == "min-height")
            cssClass = "pageContent";

        else
            cssClass = "v-previewZoneContainer";
    }
    else if (elementType == "navigationBar" || elementType == "navigationBarTop" || elementType == "navigationBarBottom")
    {
        cssClass = elementType + "Container";
        var cssProp = cssProperty || "";

        if (themeEditor.isModule && (eventType == "font" || (eventType == "color" && cssProp != "border-color")))
            cssClass += " .v-allButtons";
    }
    else if ((elementType == "questionText" || elementType == "questionName" || elementType == "errorMessage") && eventType != "font")
    {
        cssClass = elementType + "Container";
    }
    else if (elementType == "cardSort")
    {
        if (element.closest(".v-cardSortChoiceSettings").length > 0)
            cssClass = "bucket";
        else
            cssClass = "card";
    }
    else if (elementType == "dragDropRanking")
    {
        if (element.closest(".v-dragDropItemSettings").length > 0)
            cssClass = "dragDropItem";

        else if (element.closest(".v-choiceListSettings").length > 0)
            cssClass = "dragDropChoiceList";

        else
            cssClass = "dragDropAnswerList";
    }
    else if (elementType == "separator")
    {
        cssClass = "separator-item";
    }
    else if (elementType == "choiceText")
    {
        if ((typeof cssProperty == "undefined" || cssProperty == "") || (cssProperty != "margin-left" && cssProperty != "margin-top"))
            cssClass = elementType;
        else
        {
            if (cssProperty == "margin-left")
                cssClass = "choiceContainer";
            else
                if (cssProperty == "margin-top" && element.closest(".v-choiceContainer").length > 0)
                    cssClass = "choiceContainer"
                else
                    cssClass = "choiceHeader";
        }
    }
    else if (elementType == "body")
    {
        cssClass = "previewZone"
    }
    else if (elementType == "allTextFont")
    {
        cssClass = "typeTextFormat, .errorMessage, .questionText, .questionName, .choiceText";
    }
    else if (elementType == "pageHeader" || elementType == "pageFooter")
    {
        if (element.closest(".v-headerFooter").hasClass("v-headerFooterMobile"))
            cssClass = elementType + "Mobile";
    }

    return cssClass;
}

themeEditor.getThemeElementType = function (previewClass) {
    var elementType = previewClass;

    switch (previewClass) {
        case "gridColumnSettings":
            elementType = "gridColumnHeader";
            break;

        case "gridRowSettings":
            elementType = "gridRowHeader";
            break;

        case "gridItem":
            elementType = "grid";
            break;

        case "v-previewZoneContainer":
            elementType = "pageSetup";
            break;

        case "separator-item":
            elementType = "separator";
            break;

        case "previewZone":
            elementType = "body";
            break;
    }

    if (previewClass.indexOf("v-allButtons") != -1 || previewClass.indexOf("typeTextFormat") != -1)
        elementType = themeEditor.activeClass;

    return elementType;
}

themeEditor.activeClassImagesAreOnBackground = function (activeClass) {
    return (activeClass == "pageBackground" || activeClass == "body" || activeClass == "questionBlock" || activeClass == "questionBackground" || activeClass == "questionText" || activeClass == "progressBar");
}

themeEditor.initializeCurrentBlockQuestions = function () {
    var themeEditorContinaer = themeEditor.container;
    var selectedQuestion = $(".v-selectQuestion", themeEditor.container).val();
    var blockId = $(".v-selectBlock", themeEditor.container).val();

    $(".v-selectQuestion option", themeEditor.container).each(function () {
        themeEditor.questions.push({ value: $(this).val(), blockId: $(this).attr("data-block"), text: $(this).text() });
    });

    themeEditor.setSelectQuestionList(blockId);
    $(".v-selectQuestion", themeEditor.container).val(selectedQuestion);

    // If not all are displayed then load 
    if (selectedQuestion != "") {
        $(".v-itemContainer[id!='Question" + selectedQuestion + "']", themeEditor.previewZone).hide();
        //themeEditor.loadHiddenQuestionPreviews(blockId);
    }
}

themeEditor.setSelectQuestionList = function (blockId) {
    var selectQuestions = $(".v-selectQuestion", themeEditor.container);
    $(".v-selectQuestion option[value!='']", themeEditor.container).remove();

    _.each(_.filter(themeEditor.questions, function (item) { return item.blockId == blockId; }), function (q) {
        selectQuestions.append($("<option></option>").attr("value", q.value).text(q.text));
    });
}

themeEditor.setEditBlockEvent = function () {
    $(".v-selectBlock", themeEditor.container).on("change", function () {
        var blockId = $(this).val();
        themeEditor.saveConfiguration("Block", blockId);
        themeEditor.setSelectQuestionList(blockId);

        var selectedBlock = $(this).find("option:selected");
        var blockThemeId = selectedBlock.attr("data-themeid");
        var isOverridden = (selectedBlock.attr("data-overridden") === 'true');

        var overriddenNotice = $(".override-notice");
        overriddenNotice.toggle(Boolean(isOverridden));

        if (blockThemeId == "0" || $(".v-previewZoneContainer[data-themeid='" + blockThemeId + "']", themeEditor.previewZone).length > 0) {
            themeEditor.selectQuestionAfterBlockChange(blockThemeId, selectedBlock);
        }
        else {
            a4.callServerMethod(a4.getSurveyAction("GetPreviewForTheme", "LookAndFeel"), { themeId: blockThemeId, blockId: blockId, displayBlockThemeIsOverridden: themeEditor.displayBlockThemeIsOverridden },
			    function (result) {
			        themeEditor.previewZone.empty();
			        themeEditor.previewZone.append(result);
			        themeEditor.selectQuestionAfterBlockChange(blockThemeId, selectedBlock);
			    },
			    function (error) {
			        a4.onAjaxPageMethodError(error);
			    },
                { blockElement: themeEditor.previewZone }
            );
        }
    });
}

themeEditor.selectQuestionAfterBlockChange = function (themeId, selectedBlock) {
    var blockId = selectedBlock.val();
    var blockItems = $(".v-itemContainer[data-block='" + blockId + "']", themeEditor.previewZone);
    blockItems.show();

    if (selectedBlock.attr("data-rendered") == "False") {
        themeEditor.loadHiddenQuestionPreviews(blockId, blockItems);
        selectedBlock.attr("data-rendered", "True");
    }
    else {
        themeEditor.setRadioAndCheckboxDisplay(blockItems);
    }

    $(".v-previewZoneContainer[data-themeid!='" + themeId + "']", themeEditor.previewZone).hide();
    blockItems.show();
    $(".v-selectQuestion", themeEditor.container).val("");
    $(".v-selectQuestion", themeEditor.container).trigger("change");
}

themeEditor.loadHiddenQuestionPreviews = function (blockId, blockItems) {
    $(".h-waitingIcon", themeEditor.previewZone).show();
    $("body").addClass("wait");

    a4.callServerMethod(a4.getSurveyAction("GetBlockQuestionsRendering", "LookAndFeel"), { blockId: blockId },
		function (result) {
		    var content = $(result.d);

		    jQuery.each(content, function () {
		        var content = $(this);
		        var questionId = content.attr("data-questionId");
		        var questionPreview = $(".v-questionPreview[data-questionid='" + questionId + "']", themeEditor.previewZone);

		        if (questionPreview.length > 0) {
		            questionPreview.html(content.html());
		            themeEditor.setDisableEnterKeyEvent(questionPreview);
		        }
		    });

		    // init display from SE
		    initializeCardSorts();
		    initializeDragDrops();
		    initImageAreaSelectors();
		    initSliders();
		    initStarRatings();
		    initializeLookupTables();

		    themeEditor.setRadioAndCheckboxDisplay(blockItems);
		    themeEditor.applyModifedSettingsToBlock(blockId);
		    themeEditor.applyDisplaySettingsOfQuestions();

		    $(".h-waitingIcon", themeEditor.previewZone).hide();
		    $("body").removeClass("wait");
		},
		function (error) {
		    $(".h-waitingIcon", themeEditor.previewZone).hide();
		    $("body").removeClass("wait");
		},
        { blockElement: themeEditor.previewZone }
    );
}

themeEditor.applyModifedSettingsToBlock = function (blockId) {
    var questions = $(".v-itemContainer[data-block='" + blockId + "']", themeEditor.previewZone);
    var val = null;

    $.each(themeEditor.historicalSettings, function (cssClass, properties) {
        $.each(properties, function (property, value) {
            val = (property.indexOf("width") != -1 || property.indexOf("height") != -1) ? value + "px" : value;
            $("." + cssClass, questions).css(property, val);
        });
    });
}

themeEditor.setEditQuestionEvent = function () {
    themeEditor.container.on("change", ".v-selectQuestion", function () {
        themeEditor.saveConfiguration("PreviewItem", $(this).val());
        $(".v-itemContainer:visible", themeEditor.previewZone).hide();

        var items = $(this).val() === ""
            ? $(".v-itemContainer[data-block='" + $(".v-selectBlock", themeEditor.container).val() + "']", themeEditor.previewZone)
            : $("#Question" + $(this).val(), themeEditor.previewZone);

        items.show();

        $(".starRating", items).starRating("refreshLayout");
        $('.v-initializable', items).trigger('init');
    });
}

themeEditor.setEditItemEvent = function () {
    themeEditor.container.on("click", ".v-selectItem", function () {
        $(".v-selectItem", themeEditor.container).removeClass("inEdit").removeClass("flex-container");
        $(this).addClass("inEdit").addClass("flex-container");
        themeEditor.selectItemChange($(this), false);
    });
}

themeEditor.refreshTooltips = function () {
    if (!themeEditor.isModule)
    {
        themeEditor.tooltipsVisible = $("input[name='TooltipsVisibility']:checked", themeEditor.displayZone).val() == "TooltipsShow";
        themeEditor.setTooltips(themeEditor.tooltipsVisible);    
    }
}

themeEditor.selectItemChange = function (item) {
    var value = $(item).attr("data-value");
    themeEditor.saveConfiguration("SurveyItem", value);

    if (value == "display") {
        $(".v-editThemeElement.inEdit", themeEditor.editorZone).removeClass("inEdit").removeClass("flex-container");
        themeEditor.displayZone.show();
    }
    else {
        themeEditor.displayZone.hide();
        themeEditor.activeClass = value;
        var _elementType = themeEditor.activeClass.charAt(0).toUpperCase() + themeEditor.activeClass.substring(1) + "Edit";
        var editSubSection = $("." + _elementType, themeEditor.editorZone);

        if ($("." + _elementType, themeEditor.editorZone).html()) {
            themeEditor.showEditSection(_elementType);
            themeEditor.initEditorSection(_elementType, editSubSection);
        }
        else {
            $("body").addClass("wait");
            var _elementTypeValue = _elementType.trim().replace(/Edit$/, "");

            var args = { themeId: themeEditor.themeId, themeElementType: _elementTypeValue };
            a4.callServerMethod(a4.getSurveyAction("GetEditorControl", "LookAndFeel"), args,
			    function (result) {
			        editSubSection.html(result);
			        themeEditor.initEditorSection(_elementType, editSubSection);
			    },
			    function (error) {
			        a4.onAjaxPageMethodError(error);
			    },
                { blockElement: $(".v-leftPanel", themeEditor.container) }
            );
        }
    }
}

themeEditor.initEditorSection = function (_elementType, editSubSection) {
    themeEditor.showEditSection(_elementType);  // changes inEdit
    themeEditor.initializeSection(editSubSection);  // Set active class and items			            
    themeEditor.setButtonsEditAfterLoad(editSubSection);
    themeEditor.applySecurity();
    themeEditor.setModuleDisplay(themeEditor.container);
    themeEditor.refreshTooltips();

    if (_elementType == "BackButtonEdit" || _elementType == "NextButtonEdit" || _elementType == "QuitButtonEdit")
        themeEditor.selectButtonPosition(_elementType);

    if (themeEditor.isModule && _elementType == "ProgressBarEdit")
    {
        var progressBarLocation = $(".v-progressBarDropdown", editSubSection).val();
        $(".v-verticalAlignContainer", editSubSection).toggle(progressBarLocation == "Left" || progressBarLocation == "Right");
    }

    if (_elementType == "PageHeaderEdit" || _elementType == "PageFooterEdit")
    {
        var useHeaderFooterMobile = $(".v-useHeaderFooterMobile", editSubSection).is(":checked");
        $(".v-headerFooterMobile", editSubSection).toggle(useHeaderFooterMobile === true);
    }

    a4ImageSelector.bindElements(editSubSection);

    if ($("#displayMobileOnly").is(":checked"))
        $(".v-leftPanel .v-mobileExcluded").hide();

    $("input", editSubSection).on("keypress", function (_e) { return (_e.keyCode != 13); });
}

themeEditor.selectButtonPosition = function (elementType) {
    var position = "none";

    if (elementType == "BackButtonEdit") {
        position = themeEditor.buttonBackPosition;
    }
    else if (elementType == "NextButtonEdit") {
        position = themeEditor.buttonNextPosition;
    }
    else if (elementType == "QuitButtonEdit") {
        position = themeEditor.buttonQuitPosition;
    }

    $("." + elementType, themeEditor.editorZone).find(".v-positionDropdown").val(position);
}

themeEditor.setApplyTemplateEvent = function () {
    themeEditor.container.on("click", ".v-templateBrowserItems .v-items .v-templateItem", function (event) {
        var blockId = $(".v-selectBlock option:selected", themeEditor.container).val();
        var questionId = $(".v-selectQuestion  option:selected", themeEditor.container).val();
        var themeId = $(this).attr("data-themeId");
        var themeSource = $(this).attr("data-themeSource");
        var themeName = $(this).find(".templateName").html();
        var templateBrowserPreviewZone = $("#templatePanel .contentFrame .content", themeEditor.container);

        themeEditor.themeName = themeName;
        themeEditor.setSelectedTemplate(themeEditor.themeName);

        if (questionId == "") {
            questionId = themeEditor.questions[0].id;
        }

        var args = { themeId: themeId, blockId: blockId, questionId: questionId, previewSource: themeSource, displayBlockThemeIsOverridden: themeEditor.displayBlockThemeIsOverridden };
        a4.callServerMethod(a4.getSurveyAction("GetPreviewForLibraryTheme", "LookAndFeel"), args,
            function (result) {
                var questions = $(".questionBlock", themeEditor.previewZone).html();
                var previewHtml = result;

                templateBrowserPreviewZone.html(previewHtml);
                $(".questionBlock", templateBrowserPreviewZone).html(questions);
                themeEditor.setTemplatePreviewZone(templateBrowserPreviewZone);

                themeEditor.templateId = themeId;
                themeEditor.templateSource = themeSource;
            }, {},
            { blockElement: $(".v-templateBrowserItems", themeEditor.container) }
        );
    });
}

themeEditor.saveConfiguration = function (item, value) {
    // Don't save in read only mode    
    if (!themeEditor.isReadOnly) {
        themeEditor.configuration[item] = value;
        var args = {  surveyId: a4.getSurveyId, id: themeEditor.configuration.Id, settings: themeEditor.serializeConfiguration(themeEditor.configuration) };
        a4.callServerMethod(a4.getAction("UpdateUserPageConfiguration", "Shared", "Home"), args, function () { });
    }
}

themeEditor.serializeConfiguration = function (config) {
    var data = null;

    if (config) {
        var clone = $.extend({}, config);
        delete clone["Id"];
        data = JSON.stringify(clone);
    }

    return data;
}

themeEditor.setButtonsEditAfterLoad = function (editSubSection) {
    if (themeEditor.activeClass == "backButton" || themeEditor.activeClass == "nextButton" || themeEditor.activeClass == "quitButton") {
        $(".buttonText", editSubSection).each(function () {
            var _useClass = ($(this).hasClass("submit")) ? "submitButton" : themeEditor.activeClass;
            _useClass = ($(this).hasClass("buttonTooltip")) ? _useClass.replace("Button", "Tooltip") : _useClass;
            themeEditor.savedTranslatables[_useClass] = $(this).val();
        });
    }
}

themeEditor.initializeSection = function (section) {
    themeEditor.initializeRichText(section);

    var inEditItem = $(".v-editThemeElement.inEdit", themeEditor.editorZone).attr("data-section");

    if (inEditItem) {
        themeEditor.activeClass = inEditItem;
        themeEditor.setColorPickers(section);
    }
}

themeEditor.initializeRichText = function (section) {
    if ($(".editable", section).length > 0) {
        $(".editable", section).a4richTextEditor({
            inline: true,
            library: true,
            minHeight: 100,
            maxHeight: 200,
            contentChange: function () {
                var html = $(this).a4richTextEditor("getContent");
                var activeClass = themeEditor.activeClass;

                if (activeClass.toLowerCase() == "layout")
                {
                    if ($(this).hasClass("v-customPageHeader"))
                        activeClass = "pageHeader";

                    else if ($(this).hasClass("v-customPageFooter"))
                        activeClass = "pageFooter";
                }
                else if (activeClass == "pageHeader" || activeClass == "pageFooter")
                {
                    if ($(this).closest(".v-headerFooter").hasClass("v-headerFooterMobile"))
                        activeClass += "Mobile";
                }

                $("." + activeClass, themeEditor.previewZone).html(a4.decodeHtml(html));

                if (activeClass.indexOf("frame") != -1)
                    themeEditor.saveSetting(themeEditor.activeClass, "html", html);
                else
                    themeEditor.saveTranslatableValue(activeClass, html);
            }
        });

        if (themeEditor.isModule)
        {
            var pageHeader = $(".v-customPageHeader", themeEditor.container).a4richTextEditor("getContent");
            $("#HeaderLabel", themeEditor.previewZone).html(a4.decodeHtml(pageHeader));

            var pageFooter = $(".v-customPageFooter", themeEditor.container).a4richTextEditor("getContent");
            $("#PageFooterLabel", themeEditor.previewZone).html(a4.decodeHtml(pageFooter));
        }

        $(".editable:first", section).trigger("focus");
    }
}

themeEditor.showEditSection = function (_elementType) {
    $("body").removeClass("wait");
    $(".v-editThemeElement.inEdit", themeEditor.editorZone).removeClass("inEdit").removeClass("flex-container");
    $("." + _elementType, themeEditor.editorZone).addClass("inEdit").addClass("flex-container");
}

themeEditor.setColorPickers = function (editSubSection) {
    $('.v-colorPicker', editSubSection).each(function () {
        var container = $(this).closest(".v-colorDropdownContainer");
        var borderColorPicker = container.parents('.v-borderColorContainer').length || 0;
        var borderColorContainer;

        if (borderColorPicker > 0)
            borderColorContainer = $(this).closest(".v-borderColorContainer .v-colorDropdownContainer");

        var input = $(".v-colorPickerValue", $(this));
        var component = $(".v-colorPickerDisplay", $(this));
        var previewClass = themeEditor.getEventPreviewClass(input, "color");

        // If the element has inline color specified, we won't set a new color in preview.      
        if (previewClass != "separator-item")
        {
            $("." + previewClass, themeEditor.previewZone).each(function () {
                if ($(this).inlineStyle("background-color")) {
                    $(this).attr("data-hasbgcolor", "true");
                }
            });
        }

        $(this).colorpicker({
            input: input,
            component: component
        });

        themeEditor.editorZone.on("click", ".v-borderColor-all", function () {
            var borderControl = $(this).closest(".v-borderControl");

            if ($(this).is(':checked'))
            {
                var value = $(".v-borderColorContainer .v-colorPickerValue", borderControl).first().colorpicker('getValue');

                $(".v-borderColorContainer .v-colorPickerValue", borderControl).each(function (index, element) {
                    themeEditor.borderColorAllTriggered = true;
                    $(this).colorpicker('setValue', value);
                })

                themeEditor.borderColorAllTriggered = false;
            }
        });

        $(this).colorpicker().on("changeColor", function (e) {
            var color = e.value != null ? e.value : e.color.toString();
            var borderControl = $(this).closest(".v-borderControl");
            var editCss = $(".v-cssProperty", borderColorPicker > 0 ? borderColorContainer : container).val();
            themeEditor.editorItemValue = color;

            if (themeEditor.activeClass == "allTextFont")
                themeEditor.allFontTextChange(editCss, themeEditor.editorItemValue);
            else
            {
                if ($(".v-borderColor-all", borderControl).is(":checked") && !themeEditor.borderColorAllTriggered)
                {
                    $(".v-borderColorContainer .v-colorPickerValue", borderControl).each(function (index, element) {
                        $(this).val(color);
                        ($(this).parent()).find(".v-colorPickerDisplay i").css("backgroundColor", color);
                        ($(this).parent().parent()).find(".fieldChanged").val("changed");
                        editCss = ($(this).parent().parent()).find(".v-cssProperty").val();
                        themeEditor.colorChange(editCss, input);
                    })
                }
                else
                {
                    $(".v-colorPickerValue", e.currentTarget).val(color);
                    $(".v-colorPickerDisplay i", e.currentTarget).css("backgroundColor", color);
                    $(".fieldChanged", borderColorPicker > 0 ? borderColorContainer : container).val("changed");
                    themeEditor.colorChange(editCss, input);
                }
            }
        });
    });
}

themeEditor.updateThemeValue = function (selector, properties) {
    var styleElement = $(".themeStyle");

    if (styleElement.length === 1) {
        var currentStyle = $(".themeStyle").html();
        var themeClass = ".theme" + $('.v-previewZoneContainer').attr("data-themeid");

        // Find position of the current selector
        var selectorIndex = currentStyle.indexOf(selector);
        if (selectorIndex === -1) {
            currentStyle = currentStyle + "\n " + themeClass + " " + selector + " { }";
            selectorIndex = currentStyle.indexOf(selector);
        }

        // Get the properties that are defined for that selector
        var currentStyleProperties = /\{.*\}/m.exec(currentStyle.substr(selectorIndex))[0];
        for (var key in properties) {
            var value = properties[key];
            var replaceString = (value === null) ? "" : key + ": " + value;
            if (replaceString && replaceString.trim().lastIndexOf(';') === -1) { replaceString = replaceString + ";"; }

            var propertyRegex = new RegExp("(\\s|[{;])" + key + "\\s*:\\s*[^;}]+;?");

            if (propertyRegex.test(currentStyleProperties)) {
                currentStyleProperties = currentStyleProperties.replace(propertyRegex, "$1" + replaceString);
            }
            else if (/{\s*}/.test(currentStyleProperties)) {
                currentStyleProperties = "{ " + (replaceString || "") + " }";
            }
            else {
                currentStyleProperties = currentStyleProperties.replace(/;?\s*}/, ";" + (replaceString || "") + "}");
            }
        }

        currentStyle = currentStyle.substring(0, selectorIndex) + currentStyle.substr(selectorIndex).replace(/\{.*\}/m, currentStyleProperties);
        styleElement.html(currentStyle);
    }
}

themeEditor.colorChange = function (editCssProperty, _element) {
    var eventType = (editCssProperty.indexOf("font") != -1) ? "font" : "color";
    var previewClass = themeEditor.getEventPreviewClass(_element, eventType, editCssProperty);
    var previewItems = (previewClass == "body") ? themeEditor.previewZone : $("." + previewClass, themeEditor.previewZone);
    var themeElementType = themeEditor.getThemeElementType(previewClass);
    var cssProperty = "background-color";

    switch (editCssProperty) {
        case "fontColor":
            cssProperty = "color";
            break;

        case "backgroundColor":
            themeEditor.backgroundColor = themeEditor.editorItemValue;
            break;

        case "borderColor":
            cssProperty = "border-color";
            break;

        case "borderTopColor":
            cssProperty = "border-top-color";
            break;

        case "borderRightColor":
            cssProperty = "border-right-color";
            break;

        case "borderBottomColor":
            cssProperty = "border-bottom-color";
            break;

        case "borderLeftColor":
            cssProperty = "border-left-color";
            break;

        case "lookupTableRowColor":
            previewClass = "dataTable .lookupTableRow";
            themeElementType = "lookupTableRow";
            break;

        case "alternateLookupTableColor":
            previewClass = "dataTable .lookupTableAlternateRow";
            themeElementType = "lookupTableAlternateRow";
            break;

        case "highlightedLookupTableRowColor":
            previewClass = "dataTable .lookupTableHighlightedAxis";
            themeElementType = "lookupTableHighlightedAxis";
            themeEditor.gridHighlighedAxisColor = themeEditor.editorItemValue;
            break;

        case "selectedLookupTableRowColor":
            previewClass = "dataTable .lookupTableSelectedAxis";
            themeElementType = "lookupTableSelectedAxis";
            themeEditor.gridSelectedAxisColor = themeEditor.editorItemValue;
            break;

        case "LookupTableHeaderStartColor":
            previewClass = themeElementType = "lookupTableColumnHeader";
            themeEditor.applyGradientColorStyleChange(themeElementType, previewClass, _element);
            break;

        case "LookupTableHeaderStopColor":
            previewClass = themeElementType = "lookupTableColumnHeader";
            themeEditor.applyGradientColorStyleChange(themeElementType, previewClass, _element);
            break;

        case "rowColor":            // Overwrite general grid settings
            previewClass = "grid .gridRow";
            themeElementType = "gridRow";
            break;

        case "alternateRowColor":   // Overwrite general grid settings
            previewClass = "grid .gridAlternateRow";
            themeElementType = "gridAlternateRow";
            break;

        case "highlightedAxesColor":   // Overwrite general grid settings
            previewClass = "grid .gha";
            previewItems = $([]);
            themeElementType = "gridHighlightedAxis";
            themeEditor.gridHighlighedAxisColor = themeEditor.editorItemValue;
            break;

        case "selectedAxesColor":   // Overwrite general grid settings
            previewClass = "grid .gsa";
            themeElementType = "gridSelectedAxis";
            themeEditor.gridSelectedAxisColor = themeEditor.editorItemValue;
            break;

        case "progressBarColor":    // Overwrite progress bar setting
            previewClass = themeElementType = "progressBarBar";
            themeEditor.applyGradientColorStyleChange(themeElementType, previewClass, _element);
            break;

        case "progressBarGradientColor":
            cssProperty = "background-gradient-color";
            previewClass = "noClass";
            themeElementType = "progressBarBar";
            themeEditor.applyGradientColorStyleChange(themeElementType, "progressBarBar", _element);
            break;

        case "errorMessageBackgroundColor":
            previewClass = themeElementType = "errorMessageContainer";
            break;

        case "choiceHoverColor":
            previewClass = "noClass";
            previewItems = $([]);
            themeElementType = "choiceTextHover";
            themeEditor.choiceHoverColor = themeEditor.editorItemValue;
            break;

        case "radioChekBoxRowColor":
            previewClass = "radioCheckboxRow";
            themeElementType = "RadioCheckboxRow";
            break;

        case "radioChekBoxAlternateRowColor":
            previewClass = "radioCheckboxAlternateRow";
            themeElementType = "RadioCheckboxAlternateRow";
            break;

        default:
            cssProperty = editCssProperty;
            break;
    }

    // Reset in case preview class changed
    previewItems = previewClass != "previewZone" ? $("." + previewClass, themeEditor.previewZone) : $("." + previewClass);

    if (cssProperty === "color") {
        var properties = {};
        properties[cssProperty] = themeEditor.editorItemValue;
        themeEditor.updateThemeValue("." + previewClass, properties);
    }

    if (cssProperty === "background-color") {
        previewItems = previewItems.not("[data-hasbgcolor]");
    }

    if (themeElementType === "gridSelectedAxis" || themeElementType === "gridHighlightedAxis") {
        themeEditor.fixAxisColors();
    }

    if (themeElementType == "choiceImage" || themeElementType == "selectedImageChoice" || themeElementType == "highlightedImageChoice") {
        var properties = {};
        properties[cssProperty] = themeEditor.editorItemValue;
        themeEditor.updateThemeValue("." + previewClass + " .choiceImageOverlay", properties);
    }
    else {
        previewItems.css(cssProperty, themeEditor.editorItemValue || "transparent");
    }

    themeEditor.saveSetting(themeElementType, cssProperty, themeEditor.editorItemValue);
}

themeEditor.setGeneralDropdownChangeEvent = function () {
    themeEditor.editorZone.on("change", ".v-editDropdown", function () {
        var element = $(this);
        themeEditor.editorItemValue = element.val();

        var editCss = element.parent().find(".v-cssProperty").val();

        if (themeEditor.activeClass == "allTextFont")
            themeEditor.allFontTextChange(editCss, themeEditor.editorItemValue);
        else
        {
            element.parent().find(".v-fieldChanged").val("changed");
            themeEditor.dropDownPropertyChange(element, editCss);
        }
    });
}

themeEditor.allFontTextChange = function (editCssProperty, value) {
    $(".v-allTextFontEdit", themeEditor.editorZone).each(function () {
        var fontContext = $(this);
        var fontControl = null;

        switch (editCssProperty) {
            case "fontFamily":
                fontControl = $(".v-fontFamilyDropDown", fontContext);
                fontControl.val(value);
                break;

            case "fontSize":
                fontControl = $(".v-fontSizeDropDown", fontContext);
                fontControl.val(value);
                break;

            case "fontColor":
                fontControl = fontContext;
                break;

            case "font-weight":
                fontControl = $(".v-fontBold", fontContext);
                fontControl.prop("checked", value);
                break;

            case "font-style":
                fontControl = $(".v-fontItalic", fontContext);
                fontControl.prop("checked", value);
                break;

            case "text-decoration":
                fontControl = $(".v-fontUnderline", fontContext);
                fontControl.prop("checked", value);
                break;
        }

        if (fontControl != null)
        {
            themeEditor.activeClass = $(this).attr("data-section");

            if (editCssProperty == "fontColor")
                $(".v-colorPicker", fontControl).colorpicker("setValue", value);
            else
                fontControl.trigger("change");
        }
    });
    themeEditor.activeClass = "allTextFont";
}

themeEditor.dropDownPropertyChange = function (_element, editCssProperty) {
    var eventType = (editCssProperty.indexOf("font") != -1) ? "font" : "general";
    var previewClass = themeEditor.getEventPreviewClass(_element, eventType, editCssProperty);
    if (previewClass == "previewZone") previewClass = "body";

    var themeElementType = themeEditor.getThemeElementType(previewClass);
    var cssProperty = "";
    var eventExecuted = false;

    switch (editCssProperty) {
        case "fontFamily":
            cssProperty = "font-family";
            break;

        case "fontSize":
            cssProperty = "font-size";
            break;

        case "border-style":
        case "border-top-style":
        case "border-right-style":
        case "border-bottom-style":
        case "border-left-style":
            eventExecuted = true;
            var borderControl = _element.closest(".v-borderControl");

            if (editCssProperty == "border-style" && themeEditor.isModule)
            {
                // by default the border-style is "inset" in NVW
                var previewBorderStyle = (themeEditor.editorItemValue == "") ? "inset" : themeEditor.editorItemValue;

                $(".v-borderStyleContainer .v-editDropdown", borderControl).parent().find(".v-fieldChanged").val("changed");
                $("." + previewClass, themeEditor.previewZone).css("border-style", previewBorderStyle);
                themeEditor.saveSetting(themeElementType, "border-style", themeEditor.editorItemValue);
            }
            else if ($(".v-borderStyle-all", borderControl).is(":checked") && !themeEditor.borderStyleAllTriggered)
            {
                $(".v-borderStyleContainer .v-editDropdown", borderControl).each(function (index, element) {
                    $(this).parent().find(".v-fieldChanged").val("changed");
                    var editCss = $(this).parent().find(".v-cssProperty").val();
                    var side = themeEditor.getSide(editCss, "border", "style");
                    $(this).val(themeEditor.editorItemValue);

                    if (themeElementType == "choiceImage" || themeElementType == "selectedImageChoice" || themeElementType == "highlightedImageChoice") {
                        var properties = {};
                        properties[editCss] = themeEditor.editorItemValue;
                        themeEditor.updateThemeValue("." + previewClass + " .choiceImageOverlay", properties);
                    }
                    else {
                        themeEditor.applyBorderSideStyleChange(themeElementType, previewClass, themeEditor.editorItemValue, side, borderControl);
                    }

                    themeEditor.saveSetting(themeElementType, "border-" + side.toLowerCase() + "-style", themeEditor.editorItemValue);
                });
            }
            else
            {
                cssProperty = editCssProperty;
                var value = $(".v-borderStyleContainer .v-editDropdown", borderControl).val();
                var side = themeEditor.getSide(editCssProperty, "border", "style");

                if (themeElementType == "choiceImage" || themeElementType == "selectedImageChoice" || themeElementType == "highlightedImageChoice") {
                    var properties = {};
                    properties[cssProperty] = themeEditor.editorItemValue;
                    themeEditor.updateThemeValue("." + previewClass + " .choiceImageOverlay", properties);
                }
                else {
                    themeEditor.applyBorderSideStyleChange(themeElementType, previewClass, themeEditor.editorItemValue, side, borderControl);
                }

                themeEditor.saveSetting(themeElementType, editCssProperty, themeEditor.editorItemValue);
            }
            break;

        case "borderSide":
            eventExecuted = true;
            var borderControl = _element.closest(".v-borderControl");
            var style = $(".v-borderStyleContainer .v-editDropdown", _element.closest(".v-borderControl")).val();
            themeEditor.applyBorderSideChange(themeElementType, previewClass, themeEditor.editorItemValue, borderControl);
            break;

        case "paddingSide":
            eventExecuted = true;
            var paddingControl = _element.closest(".v-paddingControl");
            $(".v-paddingSettingsContainer", paddingControl).toggle(themeEditor.editorItemValue != "None");
            var width = $(".v-paddingSettingsContainer .v-paddingWidth", paddingControl).val();
            width = (width === "") ? "" : width + "px";
            themeEditor.applyPaddingChange(themeElementType, previewClass, themeEditor.editorItemValue, width);
            themeEditor.saveSetting(themeElementType, "paddingSideValue", themeEditor.editorItemValue);
            break;

        case "floatAlign":
            eventExecuted = true;
            cssProperty = "float";
            var itemValue = themeEditor.editorItemValue;

            if (themeEditor.activeClass == "navigationBarTop" || themeEditor.activeClass == "navigationBarBottom" || themeEditor.activeClass == "progressBar" || themeEditor.activeClass == "progressBarBar")
            {
                if (themeEditor.activeClass == "navigationBarTop" || themeEditor.activeClass == "navigationBarBottom")
                    previewClass = themeElementType = themeEditor.activeClass + "Container";
                else
                    previewClass = themeElementType = "progressBarContainer";

                themeEditor.executeFloatAlignChange(previewClass, itemValue);
                themeEditor.saveSetting(themeElementType, cssProperty, itemValue);
            }
            else if (themeEditor.activeClass.indexOf("Button") != -1)
            {
                previewClass = themeElementType = ("navigation" + themeEditor.activeClass.charAt(0).toUpperCase() + themeEditor.activeClass.substring(1));

                if (!themeEditor.isModule) {
                    themeEditor.executeFloatAlignChange(previewClass, itemValue);
                }
                else {
                    $("." + themeEditor.activeClass, themeEditor.previewZone).attr("data-float", themeEditor.editorItemValue);
                }
            }
            else {
                themeEditor.executeFloatAlignChange(previewClass, itemValue);
                themeEditor.saveSetting(themeElementType, cssProperty, itemValue);
            }
            break;

        case "horizontalPosition":
            cssProperty = "text-align";
            previewClass += " legend";
            themeEditor.executeHorizontalPositionChange(themeElementType);
            break;

        case "position":
            cssProperty = "background-position";
            break;

        case "backgroundRepeat":
            cssProperty = "background-repeat";
            break;

        case "buttonType":
            eventExecuted = true;
            themeEditor.executeButtonTypeChange(_element)
            break;

        case "languageSelectorType":
            eventExecuted = true;
            themeEditor.executeLanguageSelectorTypeChange(_element);
            break;

        case "verticalAlign":
            cssProperty = "vertical-align";
            break;

        case "borderCollapse":
            cssProperty = "border-collapse";
            break;
    }

    // Button type, float align and border style/side have already been handled
    if (!eventExecuted) {
        $("." + previewClass, themeEditor.previewZone).css(cssProperty, themeEditor.editorItemValue);
        themeEditor.saveSetting(themeElementType, cssProperty, themeEditor.editorItemValue);

        if (previewClass == "body") {
            themeEditor.previewZone.css(cssProperty, themeEditor.editorItemValue);
        }
    }
}

themeEditor.executeButtonTypeChange = function (element) {
    var isCheckBox = (themeEditor.activeClass == "checkBox");
    var isRadioButton = (themeEditor.activeClass.indexOf("radio") != -1);
    var isNavBar = (themeEditor.activeClass.indexOf("navigationBarTop") != -1 || themeEditor.activeClass.indexOf("navigationBarBottom") != -1);
    var selector = "." + themeEditor.activeClass + ((isCheckBox || isRadioButton || isNavBar) ? " input" : "");
    var isRadioCheckBox = (themeEditor.activeClass == "radioCheckBox");
    selector = isRadioCheckBox ? ".checkBox input, .radioButton input" : selector;
    var activeClass = isRadioCheckBox ? "customInput" : themeEditor.activeClass;

    $(selector, themeEditor.previewZone).toggle();

    if (selector == ".questionClearButton")
        $(selector, themeEditor.previewZone).css("border-style", "");

    // hide/show image selector 
    var section = element.closest(".v-editThemeElement");
    $(".v-buttonTypeSection:not(.v-accordionSection)", section).toggle();

    // get and save theme item
    var themeElementType = activeClass.charAt(0).toUpperCase() + activeClass.substring(1) + (isCheckBox ? "Button" : "") + (isNavBar ? "Type" : "");
    themeEditor.saveThemeValue(themeElementType, themeEditor.editorItemValue);

    if (isRadioCheckBox)
    {
        var radioCheckboxType = themeEditor.editorItemValue.toLowerCase() == "true" ? "Image" : "button";
        themeEditor.checkboxType = radioCheckboxType;
        themeEditor.radioButtonType = radioCheckboxType;
        themeEditor.setRadioAndCheckboxDisplay(themeEditor.previewZone);
    }
    else if (isCheckBox) {
        themeEditor.checkboxType = themeEditor.editorItemValue;
        themeEditor.setRadioAndCheckboxDisplay(themeEditor.previewZone);
    }
    else if (isRadioButton) {
        themeEditor.radioButtonType = themeEditor.editorItemValue;
        themeEditor.setRadioAndCheckboxDisplay(themeEditor.previewZone);
    }
    else if (!themeEditor.isModule && themeEditor.editorItemValue == "Image") {
        themeEditor.clearBorderStyle(themeEditor.activeClass, themeEditor.editorZone);
    }

    if (themeEditor.isModule && isNavBar) {
        $("." + themeElementType.replace("Type", "Edit") + " .v-imageContainer").toggle(themeEditor.editorItemValue == "Image");
        $("." + themeElementType.replace("Type", "Edit") + " .v-textContainer").toggle(themeEditor.editorItemValue == "Button");
    }
}

themeEditor.executeLanguageSelectorTypeChange = function (element) {
    themeEditor.saveThemeValue("LanguageSelector", themeEditor.editorItemValue);
    $(".v-languageSelectorType.hyperlink", themeEditor.previewZone).css("display", themeEditor.editorItemValue == "Hyperlink" ? "inline" : "none");
    $(".v-languageSelectorType.dropdown", themeEditor.previewZone).css("display", themeEditor.editorItemValue != "Hyperlink" ? "inline" : "none");
}

themeEditor.applyBorderStyleChange = function (themeElementType, previewClass, borderStyle, borderSide, borderControl) {
    var element = themeEditor.getBorderStyleChangeElement(previewClass);
    var applyAll = (borderSide == "All" || borderStyle == "None" || borderSide == undefined);
    var leftValue = (applyAll || borderSide == "Left") ? borderStyle : element.css("border-left-style");
    var topValue = (applyAll || borderSide == "Top") ? borderStyle : element.css("border-top-style");
    var rightValue = (applyAll || borderSide == "Right") ? borderStyle : element.css("border-right-style");
    var bottomValue = (applyAll || borderSide == "Bottom") ? borderStyle : element.css("border-bottom-style");

    var value = (borderStyle == "None") ? "0px" : $(".v-borderWidth", borderControl).val() + "px";
    themeEditor.fixChoiceImageMargin(element, borderSide, value);

    value = topValue + " " + rightValue + " " + bottomValue + " " + leftValue;
    element.css("border-style", value);
    themeEditor.saveSetting(themeElementType, "border-style", value);
}

themeEditor.applyBorderSideStyleChange = function (themeElementType, previewClass, borderStyle, borderSide, borderControl) {
    var element = themeEditor.getBorderStyleChangeElement(previewClass);
    borderSide = borderSide.toLowerCase();
    var applyAll = (borderSide == "All" || borderSide == undefined);
    var leftValue = (applyAll || borderSide == "left") ? borderStyle : element.css("border-left-style");
    var topValue = (applyAll || borderSide == "top") ? borderStyle : element.css("border-top-style");
    var rightValue = (applyAll || borderSide == "right") ? borderStyle : element.css("border-right-style");
    var bottomValue = (applyAll || borderSide == "bottom") ? borderStyle : element.css("border-bottom-style");

    element.css("border-left-style", leftValue);
    element.css("border-top-style", topValue);
    element.css("border-right-style", rightValue);
    element.css("border-bottom-style", bottomValue);
}

themeEditor.getSide = function (element, htmlElement, property) {
    return element.replace(htmlElement + "-", "").replace("-" + property, "");
}

themeEditor.applyBorderEvents = function () {
    themeEditor.editorZone.on("click", ".v-borderStyle-all", function () {
        var borderControl = $(this).closest(".v-borderControl");

        if ($(this).is(':checked')) {
            var value = $(".v-borderStyleContainer .v-editDropdown", borderControl).first().val();

            $(".v-borderStyleContainer .v-editDropdown", borderControl).each(function (index, element) {
                themeEditor.borderStyleAllTriggered = true;
                var element = $(this);
                element.parent().find(".v-fieldChanged").val("changed");
                themeEditor.editorItemValue = value;
                $(this).val(value);
                var editCss = element.parent().find(".v-cssProperty").val();
                themeEditor.dropDownPropertyChange(element, editCss);
            });

            themeEditor.borderStyleAllTriggered = false;
        }
    });
}

themeEditor.applyBorderSideChange = function (themeElementType, previewClass, borderSide, borderControl) {
    var element = themeEditor.getBorderStyleChangeElement(previewClass);
    var applyAll = (borderSide == "All" || borderStyle == "None" || borderSide == undefined);
    var styleControl = $(".v-borderStyleContainer select", borderControl);
    var widthControl = $(".v-borderWidth", borderControl);
    var colorControl = $(".v-colorPickerValue", borderControl);
    var colorDisplay = $(".v-colorPickerDisplay", borderControl);
    var colorCssPropertyControl = $(".v-colorDropdownContainer .v-cssProperty", borderControl);

    if (applyAll) {
        var borderColor = element.css("border-color");
        borderColor = themeEditor.convertComponentToHex(borderColor);

        var borderWidth = element.css("border-width");
        borderWidth = borderWidth.substring(0, borderWidth.indexOf("px"));

        var borderStyle = element.css("border-style");
        borderStyle = borderStyle.charAt(0).toUpperCase() + borderStyle.slice(1);

        colorCssPropertyControl.val("borderColor");
    }
    else {
        var borderColor = element.css("border-" + borderSide + "-color");
        borderColor = themeEditor.convertComponentToHex(borderColor);

        var borderWidth = element.css("border-" + borderSide + "-width");
        borderWidth = borderWidth.replace("px", "");

        var borderStyle = element.css("border-" + borderSide + "-style");
        borderStyle = borderStyle.charAt(0).toUpperCase() + borderStyle.slice(1);

        colorCssPropertyControl.val("border" + borderSide + "Color");
    }

    styleControl.val(borderStyle);
    widthControl.val(borderWidth);
    colorControl.val(borderColor);
    colorDisplay.css("background-color", borderColor);
}

themeEditor.convertComponentToHex = function (rgb) {
    var strippedRGB = rgb.replace("rgb(", "").replace(")", "").replace(/^\s+/, '');
    var valuesArray = strippedRGB.split(",");

    var r = valuesArray[0];
    var g = valuesArray[1];
    var b = valuesArray[2];

    return (themeEditor.rgbValueToHex(parseInt(r), parseInt(g), parseInt(b)));
}

themeEditor.rgbValueToHex = function (r, g, b) {
    return "#" + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
}

themeEditor.getBorderStyleChangeElement = function (previewClass) {
    var filter = (previewClass == "choiceImage") ? ":not(.selectedImageChoice)" : "";
    return $("." + previewClass + filter, themeEditor.previewZone);
}

themeEditor.applyPaddingChange = function (themeElementType, previewClass, paddingSide, width) {
    var element = $("." + previewClass, themeEditor.previewZone);

    if (paddingSide == "None")
        width = "0px";

    var allSides = (paddingSide == "All" || paddingSide == "None");
    var leftValue = (allSides || paddingSide == "Left") ? width : element.css("padding-left");
    var topValue = (allSides || paddingSide == "Top") ? width : element.css("padding-top");
    var rightValue = (allSides || paddingSide == "Right") ? width : element.css("padding-right");
    var bottomValue = (allSides || paddingSide == "Bottom") ? width : element.css("padding-bottom");

    var value = topValue + " " + rightValue + " " + bottomValue + " " + leftValue;
    element.css("padding", value);
    themeEditor.saveSetting(themeElementType, "padding", value);
}

themeEditor.applyGradientColorStyleChange = function (themeElementType, previewClass, element) {
    var container = element.closest(".v-backgroundGradientContainer");
    if (container.length > 0) {
        var startColor = $(".v-gradientStartColor .v-colorPickerValue", container).val();
        var endColor = $(".v-gradientEndColor .v-colorPickerValue", container).val();

        if (endColor && endColor != "" && startColor && startColor != "")
        {
            var userAgent = navigator.userAgent.toLowerCase();

            if (/webkit/.test(navigator.userAgent.toLowerCase()))
                $("." + previewClass, themeEditor.previewZone).css("background-image", "-webkit-linear-gradient(top," + startColor + "," + endColor + ")");
            else if (a4.ie)
                $("." + previewClass, themeEditor.previewZone).css("background-image", "-ms-linear-gradient(top, " + startColor + "," + endColor + ")");
            else
                $("." + previewClass, themeEditor.previewZone).css("background-image", "-moz-linear-gradient(top," + startColor + "," + endColor + ")");
        }
        else {
            $("." + previewClass, themeEditor.previewZone).css("background-image", "none");
        }
    }
}

themeEditor.executeFloatAlignChange = function (_useClass, itemValue) {
    if (_useClass == "navigationBackButton" || _useClass == "navigationQuitButton" || _useClass == "navigationNextButton") {
        themeEditor.setNavigationBarButtonsAlign(_useClass, itemValue);
    }
    else if (!themeEditor.isModule && _useClass == "navigationBarTopContainer") {
        //themeEditor.setNavigationBarDisplay($(".navigationBarTop", themeEditor.previewZone));
    }
    else if (!themeEditor.isModule && _useClass == "navigationBarBottomContainer") {
        //themeEditor.setNavigationBarDisplay($(".navigationBarBottom", themeEditor.previewZone));
    }
    else if (_useClass == "errorMessageContainer") {
        $("." + _useClass, themeEditor.previewZone).css("text-align", themeEditor.editorItemValue);
    }
    else {
        $("." + _useClass, themeEditor.previewZone).css("float", themeEditor.editorItemValue);

        var userAgent = navigator.userAgent.toLowerCase();
        if (/webkit/.test(navigator.userAgent.toLowerCase())) {
            if (_useClass == "pageContentContainer" && $(".v-pageContentWidth", themeEditor.editorZone).val() == "") {    // When 100% dont do inline-block
                $("." + _useClass, themeEditor.previewZone).css("display", "").css("float", "none");
                $(".v-contentPosition .v-editDropdown", themeEditor.editorZone).val("none");
            }
            else {
                themeEditor.setProgressBarInChrome(_useClass, themeEditor.editorItemValue);
            }
        }
    }
}

themeEditor.setProgressBarEvents = function () {
    themeEditor.setProgressBarChangeEvent();

    themeEditor.editorZone.on("click", ".v-progressBarShowLabel", function () {
        $(".progressBarLabel", themeEditor.previewZone).toggle();
        themeEditor.saveThemeValue("ProgressBarShowLabel", $(".progressBarLabel", themeEditor.previewZone).is(":visible").toString());
    });

    themeEditor.editorZone.on("click", ".v-progressBarShowPercentage", function () {
        $(".progressBarPercentage", themeEditor.previewZone).toggle();
        themeEditor.saveThemeValue("ProgressBarShowPercentage", $(".progressBarPercentage", themeEditor.previewZone).is(":visible").toString());
    });

    themeEditor.editorZone.on("keyup", ".v-progressBarLabel", function () {
        $(".progressBarLabel", themeEditor.previewZone).html($(this).val());
        themeEditor.saveTranslatableValue("Progress", a4.encodeHtml($(this).val()));
    });
}

themeEditor.setSeparatorEvents = function () {
    themeEditor.editorZone.on("click", ".v-separatorCenter", function () {
        var value = $(this).is(":checked") ? "center" : "left";
        $(".separator-item", themeEditor.previewZone).parent().css("text-align", value);
        themeEditor.saveSetting(themeEditor.activeClass, "text-align", value);
    });

    themeEditor.editorZone.on("change", ".v-separatorTypeDropdown", function () {
        var value = $(this).val();
        $("#separator_template", themeEditor.previewZone).attr("data-type", value);
        themeEditor.separatorPreviewChange();
        themeEditor.saveSetting(themeEditor.activeClass, "type", value);
    });
}

themeEditor.setFrameEvents = function () {
    themeEditor.editorZone.on("keydown", ".v-sizeControl", function (e) {
        themeEditor.validateKeyCode(e, $(this));
        themeEditor.checkAndClearUnspecifiedValue(this);
    });

    themeEditor.editorZone.on("keyup", ".v-sizeControl", function () {
        var value = $(this).val();

        if (!value || value == "")
            value = "0";

        var property = (themeEditor.activeClass == "frameLeft" || themeEditor.activeClass == "frameRight") ? "width" : "height";
        $("#frameContent ." + themeEditor.activeClass, themeEditor.previewZone).css(property, value + "px");
        themeEditor.saveSetting(themeEditor.activeClass, "size", value);
    });

    themeEditor.editorZone.on("change", ".v-frameScrollTypeDropdown", function () {
        var value = $(this).val();
        themeEditor.saveSetting(themeEditor.activeClass, "scroll", value);
    });

    themeEditor.editorZone.on("change", ".v-frameResizable", function () {
        var checked = $(this).is(":checked");

        themeEditor.saveSetting("frameLeft", "resizable", checked);
        themeEditor.saveSetting("frameTop", "resizable", checked);
        themeEditor.saveSetting("frameRight", "resizable", checked);
        themeEditor.saveSetting("frameBottom", "resizable", checked);
    });

    themeEditor.editorZone.on("change", ".v-frameSetLayout", function () {
        themeEditor.saveSetting("FrameSet", "layout", $(this).val());
    });
}

themeEditor.setProgressBarInChrome = function (_class, value) {
    if (value == "none") { $("." + _class, themeEditor.previewZone).css("display", ""); }
    else { $("." + _class, themeEditor.previewZone).css("display", "inline-block"); }
}

themeEditor.setBackgroundEvents = function () {
    themeEditor.setBackgroundImageEvent();
    themeEditor.setButtonTextEvents();
    themeEditor.setBorderWidthEvent();
    themeEditor.setPaddingWidthEvent();
    themeEditor.setMarginWidthEvent();

    themeEditor.setUsePageBackgroundEvent();
    themeEditor.setUseBlockBackgroundEvent();
}

themeEditor.setBackgroundImageEvent = function () {
    themeEditor.editorZone.on("change", ".v-imageSelectorText", function () {
        themeEditor.imageSelectorImageValueChange($(this), $(this).val().trim(), $(this).attr("data-url"));
        var _bgSettingsContainer = $(".v-backgroundSettingsContainer:visible", themeEditor.editorZone);

        if (_bgSettingsContainer.length > 0) {
            var _activeElement = (themeEditor.activeClass == "body") ? themeEditor.previewZone : $("." + themeEditor.activeClass, themeEditor.previewZone);
            var _position = $(".v-positionDropdown ", _bgSettingsContainer).val();
            var _repeat = $(".v-repeatDropdown ", _bgSettingsContainer).val();

            _activeElement.css("background-position", _position);
            _activeElement.css("background-repeat", _repeat);

            themeEditor.saveSetting(themeEditor.activeClass, "background-position", _position);
            themeEditor.saveSetting(themeEditor.activeClass, "background-repeat", _repeat);
        }
    });

    themeEditor.editorZone.on("change", ".v-clearImage", function () {
        var _parent = $(this).closest(".imageSelector");
        $(".imageSelectorText", _parent).val("");
        themeEditor.imageSelectorImageValueChange($(this), "", "");

        if ($(".backgroundSettingsContainer:visible", themeEditor.editorZone).length > 0) {
            var _activeElement = $("." + themeEditor.activeClass, themeEditor.previewZone);
            _activeElement.css("background-position", "");
            _activeElement.css("background-repeat", "");
            themeEditor.saveSetting(themeEditor.activeClass, "background-position", "");
            themeEditor.saveSetting(themeEditor.activeClass, "background-repeat", "");
        }

        return false;
    });
}

themeEditor.imageSelectorImageValueChange = function (selectorItem, value, url) {
    var startValue = value;
    var imageSelector = selectorItem.closest(".v-imageSelector");
    var selectorText = $(".v-imageSelectorText", imageSelector);
    var activeClass = themeEditor.activeClass;
    selectorText.val(value);

    if (activeClass == "radioCheckBox")
        activeClass = selectorItem.hasClass("v-radioButton") ? "radioButton" : "checkBox";

    if (themeEditor.isModule && value != "" && typeof url !== "undefined")
        value = url;

    // Change the visibility of the image settings (if they are there)
    var imageContainer = imageSelector.closest(".v-imageContainer");

    if (imageContainer.length > 0)
        imageContainer.next(".v-imageSettings").toggle(value !== "");

    var itemSelector = "." + activeClass;

    if (activeClass.indexOf("checkBox") != -1 || activeClass.indexOf("radio") != -1)
    {
        itemSelector += " input";
    }

    var isImage = !themeEditor.activeClassImagesAreOnBackground(activeClass);
    var isHoverImage = isImage && imageSelector.closest(".v-hoverImage").length > 0;

    // Put default image when no selection made for inputs and images
    if (value === "" && !isHoverImage && (isImage || $(itemSelector, themeEditor.previewZone).is(":input"))) {
        value = themeEditor.defaultVoxcoImage;
    }

    var property = activeClass.charAt(0).toUpperCase() + activeClass.substring(1);

    if (activeClass == "progressBar") {
        itemSelector += "Bar";
        property = "ProgressBackgroundImage";
    }
    else if (activeClass == "questionText") {
        itemSelector += "Container";
        property = "QuestionTextBackgroundImage";
    }
    else if (activeClass == "body") {
        itemSelector = "#previewZone";
        property = "BodyImage";
    }
    else if (activeClass == "navigationBarTop" || activeClass == "navigationBarBottom") {
        property += selectorItem.attr("data-item");
        itemSelector += " ." + selectorItem.closest(".wrapper").attr("data-item");
    }
    else if (activeClass == "separator") {
        property = "SeparatorImage";
    }

    // Change save property and update preview
    if (property === "StarRating") {
        property = imageContainer.attr("data-item");
        themeEditor.updateStarRatingImageChange(imageContainer, value);
    }
    else if (imageSelector.closest(".v-submitImage").length > 0) {
        property = (isHoverImage) ? "SubmitButtonHoverImage" : "SubmitButtonImage";
    }
    else if (isHoverImage) {
        property += "HoverImage";
    }
    else if (activeClass == "separator") {
        $('.separator-item', themeEditor.previewZone).css("background-image", "url('" + value + "')");
    }
    else if (isImage) {
        var imageTypeSelector = ($(itemSelector, themeEditor.previewZone).is("img")) ? "img" + itemSelector :
                                    selectorText.hasClass("withUpdate") ? itemSelector + ":image:not(.selected)" : itemSelector + ".selected:image";

        var imageItem = $(imageTypeSelector, themeEditor.previewZone);
        imageItem.attr("src", value);

        if (imageItem.hasClass("mustToggle")) {
            imageItem.toggle(startValue != "");
        }

        if (activeClass != "navigationBarTop" && activeClass != "navigationBarBottom") {
            property += (imageSelector.closest(".v-selectedImageDiv").length > 0) ? "SelectedImage" : "Image";
        }
    }
    else if (activeClass == "body") {
        themeEditor.previewZone.css("background-image", "url('" + value + "')");
    }
    else {
        $(itemSelector, themeEditor.previewZone).css("background-image", "url('" + value + "')");
    }

    themeEditor.updateThemeImageSetting(imageContainer, value);
    themeEditor.saveTranslatableValue(property, startValue);
}

themeEditor.updateStarRatingImageChange = function (imageContainer, value) {
    if (value) {
        themeEditor.updateThemeValue(imageContainer.attr('data-selector'), {
            "background-image": "url('" + value + "')",
            "width": "0px",
            "height": "0px",
            "background-position": "0px 0px"
        });
    }
    else {
        themeEditor.updateThemeValue(imageContainer.attr('data-selector'), {
            "background-image": null,
            "width": null,
            "height": null,
            "background-position": null
        });
    }

    $('.starRating').starRating("refreshLayout");
}

themeEditor.updateThemeImageSetting = function (imageContainer, value) {
    var data = imageContainer.attr("data-item");

    switch (imageContainer.attr("data-item")) {
        case "checkboxDefault": themeEditor.checkBoxImage = value; break;
        case "checkboxSelected": themeEditor.checkBoxSelectedImage = value; break;
        case "radioButtonDefault": themeEditor.radioButtonImage = value; break;
        case "radioButtonSelected": themeEditor.radioButtonSelectedImage = value; break;
        case "BackButtonHover": themeEditor.backButtonHoverImage = value; break;
        case "NextButtonHover": themeEditor.nextButtonHoverImage = value; break;
        case "QuitButtonHover": themeEditor.quitButtonHoverImage = value; break;
        case "QuestionClearButtonHover": themeEditor.questionClearButtonHoverImage = value; break;
    }
}

// Used when changing a button's button type from image to button
themeEditor.clearBorderStyle = function (themeElementType, container) {
    var themeElementEditor = container.find("." + themeElementType.charAt(0).toUpperCase() + themeElementType.slice(1) + "Edit");
    var colorContainer = $(".v-colorDropdownContainer input.cssProperty[value=borderColor]", themeElementEditor).parent();
    $(".v-fieldChanged", colorContainer).val("changed");
    $("." + themeElementType, themeEditor.previewZone).css("border-style", "none");
}

themeEditor.setLanguageSelectorEvents = function () {
    themeEditor.setLanguageSelectorChangeEvent();

    themeEditor.editorZone.on("click", ".v-languageSelectorShowLabel", function () {
        var value = $("input", $(this)).is(":checked");
        $(".v-languageSelectorLabel", themeEditor.previewZone).toggle(value);
        themeEditor.saveThemeValue("LanguageSelectorShowLabel", value.toString());
    });

    themeEditor.editorZone.on("keyup", ".v-languageSelectorLabel", function () {
        $(".v-languageSelectorLabel", themeEditor.previewZone).html($(this).val());
        themeEditor.saveTranslatableValue("LanguageSelector", a4.encodeHtml($(this).val()));
    });
}

themeEditor.setNavigationBarEvents = function () {
    themeEditor.editorZone.on("click", ".v-mobileUseStandardButtons", function () {
        var value = $("input", $(this)).is(":checked");
        themeEditor.saveThemeValue("MobileUseStandardButtons", value.toString());
    });
}

themeEditor.setFontEvents = function () {
    themeEditor.setFontBoldEvent();
    themeEditor.setFontItalicEvent();
    themeEditor.setFontUnderlineEvent();
}

themeEditor.setFontBoldEvent = function () {
    themeEditor.editorZone.on("change", ".v-fontBold", function () {
        if (themeEditor.activeClass == "allTextFont")
            themeEditor.allFontTextChange("font-weight", $(this).is(":checked"));
        else
        {
            var _weightValue = ($(this).is(":checked")) ? "bold" : "normal";
            var previewClass = themeEditor.getEventPreviewClass($(this), "font");
            $("." + previewClass, themeEditor.previewZone).css("font-weight", _weightValue);
            themeEditor.saveModifiedSetting("font-weight", previewClass, _weightValue);
        }
    });
}

themeEditor.setFontItalicEvent = function () {
    themeEditor.editorZone.on("change", ".v-fontItalic", function () {
        if (themeEditor.activeClass == "allTextFont")
            themeEditor.allFontTextChange("font-style", $(this).is(":checked"));
        else
        {
            var previewClass = themeEditor.getEventPreviewClass($(this), "font");
            var _styleValue = ($(this).is(":checked")) ? "italic" : "normal";
            $("." + previewClass, themeEditor.previewZone).css("font-style", _styleValue);
            themeEditor.saveModifiedSetting("font-style", previewClass, _styleValue);
        }
    });
}

themeEditor.setFontUnderlineEvent = function () {
    themeEditor.editorZone.on("change", ".v-fontUnderline", function () {
        if (themeEditor.activeClass == "allTextFont")
            themeEditor.allFontTextChange("text-decoration", $(this).is(":checked"));
        else
        {
            var previewClass = themeEditor.getEventPreviewClass($(this), "font");
            var _decorationValue = ($(this).is(":checked")) ? "underline" : "none";
            $("." + previewClass, themeEditor.previewZone).css("text-decoration", _decorationValue);
            themeEditor.saveModifiedSetting("text-decoration", previewClass, _decorationValue);
        }
    });
}

themeEditor.fixChoiceImageMargin = function (element, side, value) {
    // Fix border for images
    if (themeEditor.activeClass == "v-selectedImageChoice") {
        var marginProp = (side == "All") ? "margin" : "margin-" + side.toLowerCase();
        $("img", element).css(marginProp, "-" + value);

    }
}

themeEditor.setMarginWidthEvent = function () {
    themeEditor.editorZone.on("keydown", ".v-marginWidth", function (event) {
        themeEditor.validateKeyCode(event, $(this));
    });

    themeEditor.editorZone.on("click", ".v-marginSettingsContainer .v-marginWidth-all", function () {
        if ($(this).is(':checked')) {
            var marginControl = $(this).closest(".v-marginControl");
            var value = $(".v-marginSettingsContainer .v-marginWidth", marginControl).first().val();

            $(".v-marginSettingsContainer .v-marginWidth", marginControl).each(function (index, element) {
                $(this).val(value);
                $(this).trigger("keyup");
            })
        }
    });

    themeEditor.editorZone.on("keyup", ".v-marginWidth", function () {
        var element = $(this);
        var marginControl = element.closest(".v-marginControl");
        var panel = $(this).closest(".v-panelControl");
        var side = $(".v-editDropdown", marginControl).val();

        $(".v-fieldChanged", element.parent()).val("changed");
        themeEditor.editorItemValue = element.val();

        var _maxPx = 100;

        if ($(this).val() >= _maxPx) {
            $(this).val(_maxPx);
        }
       
        if ($(".v-marginSettingsContainer .v-marginWidth-all", marginControl).is(":checked"))
        {
            $(".v-marginSettingsContainer .v-marginWidth", marginControl).val(element.val());
            side = "All";
        }

        if (typeof side == "undefined")
            side = themeEditor.getSide($(".v-cssProperty", element.closest(".v-marginWidthContainer")).val(), "margin", "width");

        var previewClass = themeEditor.getEventPreviewClass(element, "margin", "marginSide");
        var themeElementType = themeEditor.getThemeElementType(previewClass);

        var value = ($(this).val() === "") ? "" : $(this).val() + "px";
        var prop = (side == "All" || side == undefined) ? "margin" : "margin-" + side.toLowerCase();
        var element = $("." + previewClass, themeEditor.previewZone);

        element.css(prop, value);
        value = value.replace("px", "");

        if (side != "All") {
            themeEditor.saveModifiedSetting(prop, previewClass, value);
        }
        else {
            themeEditor.saveModifiedSetting("margin", previewClass, value);
            themeEditor.saveModifiedSetting("margin-left", previewClass, value);
            themeEditor.saveModifiedSetting("margin-top", previewClass, value);
            themeEditor.saveModifiedSetting("margin-bottom", previewClass, value);
            themeEditor.saveModifiedSetting("margin-right", previewClass, value);
        }
    });
}

themeEditor.setPaddingWidthEvent = function () {
    themeEditor.editorZone.on("keydown", ".v-paddingWidth", function (event) {
        themeEditor.validateKeyCode(event, $(this));
    });

    themeEditor.editorZone.on("click", ".v-paddingSettingsContainer .v-paddingWidth-all", function () {
        if ($(this).is(':checked'))
        {
            var paddingControl = $(this).closest(".v-paddingControl");
            var value = $(".v-paddingSettingsContainer .v-paddingWidth", paddingControl).first().val();

            $(".v-paddingSettingsContainer .v-paddingWidth", paddingControl).each(function (index, element) {
                $(this).val(value);
                $(this).trigger("keyup");
            })
        }
    });

    themeEditor.editorZone.on("keyup", ".v-paddingWidth", function () {
        var element = $(this);
        var paddingControl = element.closest(".v-paddingControl");
        var panel = $(this).closest(".v-panelControl");
        var side = $(".v-editDropdown", paddingControl).val();

        $(".v-fieldChanged", element.parent()).val("changed");
        themeEditor.editorItemValue = element.val();

        var _maxPx = 100;

        if ($(this).val() >= _maxPx){
            $(this).val(_maxPx);
        }

        if ($(".v-paddingSettingsContainer .v-paddingWidth-all", paddingControl).is(":checked"))
        {
            $(".v-paddingSettingsContainer .v-paddingWidth", paddingControl).val(element.val());
            side = "All";
        }

        if (typeof side == "undefined")
            side = themeEditor.getSide($(".v-cssProperty", element.closest(".v-paddingWidthContainer")).val(), "padding", "width");

        var previewClass = themeEditor.getEventPreviewClass(element, "padding", "paddingSide");
        var themeElementType = themeEditor.getThemeElementType(previewClass);

        var value = ($(this).val() === "") ? "" : $(this).val() + "px";
        var prop = (side == "All" || side == undefined) ? "padding" : "padding-" + side.toLowerCase();
        var element = $("." + previewClass, themeEditor.previewZone);

        element.css(prop, value);
        value = value.replace("px", "");

        if (side != "All") {
            themeEditor.saveModifiedSetting(prop, previewClass, value);
        }
        else {
            themeEditor.saveModifiedSetting("padding", previewClass, value);
            themeEditor.saveModifiedSetting("padding-left", previewClass, value);
            themeEditor.saveModifiedSetting("padding-top", previewClass, value);
            themeEditor.saveModifiedSetting("padding-bottom", previewClass, value);
            themeEditor.saveModifiedSetting("padding-right", previewClass, value);
        }
    });
}

themeEditor.setBorderWidthEvent = function () {
    themeEditor.editorZone.on("keydown", ".v-borderWidth", function (event) {
        themeEditor.validateKeyCode(event, $(this));
    });

    themeEditor.editorZone.on("click", ".v-borderWidth-all", function () {
        var borderControl = $(this).closest(".v-borderControl");
        if ($(this).is(':checked')) {
            var value = $(".v-borderSideContainer .v-borderWidth", borderControl).first().val();
            $(".v-borderSideContainer .v-borderWidth", borderControl).each(function (index, element) {
                $(this).val(value);
                $(this).trigger("keyup");
            })
        }
    });

    themeEditor.editorZone.on("keyup", ".v-borderWidth", function () {
        var panel = $(this).closest(".v-borderControl");
        var element = $(this);
        $(".v-fieldChanged", element.parent()).val("changed");
        themeEditor.editorItemValue = element.val();

        var _maxPx = 30;

        if (element.val() >= _maxPx)
            element.val(_maxPx);

        if (themeEditor.isModule)
            themeEditor.setBorderWidth(panel, element);
        else
            themeEditor.setBorderSideWidth(panel, element);
    });
}

themeEditor.setBorderWidth = function (panel, element) {
    var previewClass = themeEditor.getEventPreviewClass(element, "border");
    var themeElementType = themeEditor.getThemeElementType(previewClass);
    var value = (element.val() === "") ? "" : element.val() + "px";
    var prop = "border-width";

    element = $("." + previewClass, themeEditor.previewZone);
    element.css(prop, value);

    themeEditor.saveModifiedSetting(prop, themeElementType, value.replace("px", ""));
}

themeEditor.setBorderSideWidth = function (panel, element) {
    var side = $(".v-borderSideContainer .v-editDropdown", panel).val();

    if ($(".v-borderSideContainer .v-borderWidth-all", panel).is(":checked")) {
        $(".v-borderSideContainer .v-borderWidth", panel).val(element.val());
        side = "All";
    }

    if (typeof side == "undefined") {
        side = themeEditor.getSide($(".v-cssProperty", element.closest(".v-borderWidthContainer")).val(), "border", "width");
    }

    var previewClass = themeEditor.getEventPreviewClass(element, "border");
    var themeElementType = themeEditor.getThemeElementType(previewClass);

    if (previewClass == "choiceImage" || previewClass == "selectedImageChoice" || previewClass == "highlightedImageChoice") {
        themeElementType = previewClass;
        previewClass = previewClass + " .choiceImageOverlay";
    }

    //var value = (element.val() === "") ? "thin" : element.val() + "px";
    var value = (element.val() === "") ? "" : element.val() + "px";
    var prop = (side == "All" || side == undefined) ? "border-width" : "border-" + side.toLowerCase() + "-width";
    var elementChoiceImage = themeEditor.getBorderStyleChangeElement(previewClass);
    themeEditor.fixChoiceImageMargin(elementChoiceImage, side, value);

    if (previewClass == "imageMapImage")
        initImageAreaSelectors();

    if (themeElementType == "choiceImage" || themeElementType == "selectedImageChoice" || themeElementType == "highlightedImageChoice") {
        var properties = {};

        if (side != "All") {
            properties[prop] = value;
        }
        else {
            properties["border-width"] = value;
            properties["border-left-width"] = value;
            properties["border-top-width"] = value;
            properties["border-bottom-width"] = value;
            properties["border-right-width"] = value;
        }

        themeEditor.updateThemeValue("." + previewClass, properties);
    }
    else {
        element = $("." + previewClass, themeEditor.previewZone);
        element.css(prop, value);
    }

    value = value.replace("px", "");

    if (side != "All") {
        themeEditor.saveModifiedSetting(prop, themeElementType, value);
    }
    else {
        themeEditor.saveModifiedSetting("border-width", themeElementType, value);
        themeEditor.saveModifiedSetting("border-left-width", themeElementType, value);
        themeEditor.saveModifiedSetting("border-top-width", themeElementType, value);
        themeEditor.saveModifiedSetting("border-bottom-width", themeElementType, value);
        themeEditor.saveModifiedSetting("border-right-width", themeElementType, value);
    }
}

themeEditor.useDefaultButtonText = function (_button) {
    var _useValue = null;
    var _useClass = (_button.hasClass("submit")) ? "submitButton" : themeEditor.activeClass;
    _useClass = (_button.hasClass("v-buttonTooltip")) ? _useClass.replace("Button", "Tooltip") : _useClass;

    _useValue = (themeEditor.savedTranslatables[_useClass]);

    if (!_useValue) {
        switch (themeEditor.activeClass) {
            case "backButton": _useValue = $("#DefaultBack", themeEditor.container).text(); break;
            case "nextButton": _useValue = $("#DefaultNext", themeEditor.container).text(); break;
            case "quitButton": _useValue = $("#DefaultQuit", themeEditor.container).text(); break;
            case "submitButton": _useValue = $("#DefaultSubmit", themeEditor.container).text(); break;
        }
    }

    _button.val(_useValue);
    return _useValue;
}

themeEditor.getButtonPreviewClass = function (element) {
    return (element.is("[data-class]")) ? themeEditor.activeClass + " ." + element.attr("data-class") : themeEditor.activeClass;
}

themeEditor.getButtonTranslatableType = function (element) {
    return (element.is("[data-class]")) ? themeEditor.activeClass + element.attr("data-class") : themeEditor.activeClass;
}

themeEditor.setButtonTextEvents = function () {
    themeEditor.editorZone.on("keyup", ".v-buttonCaption", function () {
        if (!$(this).hasClass("v-submit")) {
            $("." + themeEditor.getButtonPreviewClass($(this)), themeEditor.previewZone).val($(this).val());
        }
    });

    themeEditor.editorZone.on("blur", ".v-buttonCaption", function () {
        var item = ($(this).hasClass("v-submit")) ? "submitButton" : themeEditor.activeClass;

        if (themeEditor.activeClass == "navigationBarTop" || themeEditor.activeClass == "navigationBarBottom")
            item = themeEditor.activeClass + $(this).attr("data-class");

        themeEditor.saveTranslatableValue(item, themeEditor.ensureButtonText($(this)));
    });

    themeEditor.editorZone.on("keyup", ".v-buttonTooltip", function () {
        $("." + themeEditor.getButtonPreviewClass($(this)), themeEditor.previewZone).attr("title", $(this).val());
    });

    themeEditor.editorZone.on("blur", ".v-buttonTooltip", function () {
        var item = ($(this).hasClass("v-submit")) ? "submitTooltip" : themeEditor.activeClass.replace("Button", "Tooltip");

        if (themeEditor.activeClass == "navigationBarTop" || themeEditor.activeClass == "navigationBarBottom")
            item = themeEditor.activeClass + $(this).attr("data-class").replace("Button", "Tooltip");

        themeEditor.saveTranslatableValue(item, themeEditor.ensureButtonText($(this)));
    });
}

themeEditor.ensureButtonText = function (buttonInput) {
    if (buttonInput.val() === "")
    {
        buttonInput.val(themeEditor.useDefaultButtonText(buttonInput));
        buttonInput.trigger("keyup");
    }
    return buttonInput.val();
}

themeEditor.setUsePageBackgroundEvent = function () {
    themeEditor.editorZone.on("change", ".v-sameAsPageBackground", function () {
        var activeElement = $("." + themeEditor.activeClass, themeEditor.previewZone);
        var useSame = $(this).find("input").is(":checked");
        $(".QuestionBlockEdit .v-backgroundSettingsContainer", themeEditor.editorZone).toggle(!useSame);

        if (useSame) {
            themeEditor.clearBackgroundImageStyle(activeElement)
        }
        else {
            themeEditor.restoreBackgroundPreview(activeElement, $(".QuestionBlockEdit .v-backgroundSettingsContainer", themeEditor.editorZone));
        }

        themeEditor.saveThemeValue("QuestionBlockBgSameAsPage", useSame ? "true" : "false");
    });
}

themeEditor.setUseBlockBackgroundEvent = function () {
    themeEditor.editorZone.on("change", ".v-sameAsQuestionBlockBackground", function () {
        var activeElement = $("." + themeEditor.activeClass, themeEditor.previewZone);
        var useSame = $(this).find("input").is(":checked");
        $(".QuestionBackgroundEdit .v-backgroundSettingsContainer", themeEditor.editorZone).toggle(!useSame);

        if (useSame) {
            themeEditor.clearBackgroundImageStyle(activeElement)
        }
        else {
            var bgSettingsContainer = $(".QuestionBackgroundEdit", themeEditor.editorZone).html()
                                            ? $(".QuestionBackgroundEdit .v-backgroundSettingsContainer", themeEditor.editorZone)
                                            : $(".questionBackground:first", themeEditor.previewZone);
            themeEditor.restoreBackgroundPreview(activeElement, bgSettingsContainer);
        }

        themeEditor.saveThemeValue("QuestionBgSameAsBlock", useSame ? "true" : "false");
    });
}

themeEditor.clearBackgroundImageStyle = function (toElement) {
    toElement.css("background-color", "transparent");
    toElement.css("background-image", "none");
}

themeEditor.restoreBackgroundPreview = function (element, bgSettingsContainer) {
    element.css("background-color", $(".v-colorDropdownContainer .v-colorPickerValue", bgSettingsContainer).val());
    element.css("background-image", "url(" + $(".v-imageSelectorText", bgSettingsContainer).val() + ")");
    element.css("background-position", $(".v-positionDropdown", bgSettingsContainer).val());
    element.css("background-repeat", $(".v-repeatDropdown", bgSettingsContainer).val());
}

themeEditor.setDimensionEvents = function () {
    themeEditor.editorZone.on("keydown", ".v-dimensionControl", function (event) {
        themeEditor.validateKeyCode(event, $(this));
        themeEditor.checkAndClearUnspecifiedValue(this);
    });

    themeEditor.editorZone.on("keyup", ".v-dimensionControl", function () {
        var property = $(this).attr("data-property");
        var previewClass = themeEditor.getEventPreviewClass($(this), "dimension", property);

        themeEditor.executeDimensionPropertyChange(previewClass, property, "", $(this));
    });
}

themeEditor.executeDimensionPropertyChange = function (previewClass, property, _defaultVal, _element) {
    var value = _element.val();

    if (value === "") {
        themeEditor.setElementValueToUnspecified(_element);
        value = _defaultVal || "";
    }

    var displayValue = (previewClass == "separator-item" && property == "width") ? value + "%" : (value !== "") ? value + "px" : "auto";
    var displayProperty = property;

    if (previewClass == "gridRowHeader") {
        previewClass = "grid tr th:first";
        displayProperty = "min-width";
    }
    else if (previewClass == "separator-item") {
        var bg = $("#QuestionBackgroundEdit .v-widthControl", themeEditor.editorZone).val();
        var bgVal = (bg == "" || bg == "-1" || bg == "0") ? "100%" : "auto";
        $(".questionBackground", themeEditor.previewZone).css("width", bgVal);
    }

    $("." + previewClass, themeEditor.previewZone).css(displayProperty, displayValue);

    var settingsClass = (previewClass == "separator-item") ? "separator" : previewClass;
    settingsClass = (themeEditor.isModule && previewClass == "grid tr th:first") ? "GridRowHeader" : settingsClass;
    themeEditor.saveModifiedSetting(property, settingsClass, value);

    // Make the question name setting follow when modifying the question background
    if (!themeEditor.isModule && previewClass == "questionBackground") {
        $(".questionNameContainer", themeEditor.previewZone).css(property, displayValue);
        themeEditor.saveModifiedSetting(property, "questionNameContainer", value);
    }
}

themeEditor.setElementValueToUnspecified = function (_element) {
    $(_element).addClass("unspecified");
}

themeEditor.setDisplayEvents = function () {
    themeEditor.displayZone.on("change", ".v-pageHeaderShow", function () {
        $(".pageHeader", themeEditor.previewZone).toggle();
        var isVisible = $(".pageHeader", themeEditor.previewZone).is(":visible").toString();
        themeEditor.saveThemeValue("PageHeaderVisible", isVisible);
    });

    themeEditor.displayZone.on("change", ".v-pageTitleShow", function () {
        $(".pageTitleContainer", themeEditor.previewZone).toggle();
        themeEditor.saveThemeValue("PageTitleVisible", $(".pageTitleContainer", themeEditor.previewZone).is(":visible").toString());
    });

    themeEditor.displayZone.on("change", ".v-pageFooterShow", function () {
        $(".pageFooter", themeEditor.previewZone).toggle();
        themeEditor.saveThemeValue("PageFooterVisible", $(".pageFooter", themeEditor.previewZone).is(":visible").toString());
    });

    themeEditor.displayZone.on("change", ".v-questionNameShow", function () {
        themeEditor.questionNameVisible = !themeEditor.questionNameVisible;
        $(".questionNameContainer", themeEditor.previewZone).toggle(themeEditor.questionNameVisible);
        themeEditor.saveThemeValue("QuestionNameVisible", themeEditor.questionNameVisible.toString());
    });

    themeEditor.displayZone.on("change", ".v-questionTextShow", function () {
        themeEditor.questionTextVisible = !themeEditor.questionTextVisible;
        $(".questionTextContainer", themeEditor.previewZone).toggle(themeEditor.questionTextVisible);
        themeEditor.saveThemeValue("QuestionLabelVisible", themeEditor.questionTextVisible.toString());
    });

    $(document).on("change", "#displayMobileOnly", function () {
        $(".v-leftPanel .v-mobileExcluded").toggle();
        var selectedItem = $('.v-selectItem.inEdit', themeEditor.container);

        if ($(this).prop("checked") && !selectedItem.is(":visible")) {
            themeEditor.displayZone.hide();
            $(".v-editThemeElement.inEdit", themeEditor.editorZone).removeClass("inEdit").removeClass("flex-container");
        }
        else if (selectedItem.hasClass("v-mobileExcluded")) {
            themeEditor.selectItemChange(selectedItem);
        }
    });

    themeEditor.displayZone.on("change", "input[name='TooltipsVisibility']", function () {
        themeEditor.tooltipsVisible = ($(this).val() == "TooltipsShow");

        //var visible = ($("*[title]", themeEditor.previewZone).length > 0);
        themeEditor.setTooltips(themeEditor.tooltipsVisible);

        themeEditor.saveThemeValue("TooltipsVisible", themeEditor.tooltipsVisible.toString());
    });
}

themeEditor.setTooltips = function (visible) {
    var next = (visible) ? "title" : "data-title";
    var current = (!visible) ? "title" : "data-title";

    $("*[" + current + "]", themeEditor.previewZone).each(function () {
        $(this).attr(next, $(this).attr(current));
        $(this).removeAttr(current);
    });
}

themeEditor.setPageEvents = function () {
    themeEditor.editorZone.on("keydown", ".v-pageSetupWidth", function (event) {
        themeEditor.validateKeyCode(event, $(this));
    });

    themeEditor.editorZone.on("keyup", ".v-pageSetupWidth", function (event) {
        var value = ($(this).val() === "") ? "100%" : $(this).val() + "px";
        $(".v-previewZoneContainer", themeEditor.previewZone).css("width", value);
        themeEditor.saveSetting(themeEditor.activeClass, "width", $(this).val().replace("px", ""));
    });

    themeEditor.editorZone.on("keydown", ".v-pageContentWidth", function (event) {
        themeEditor.validateKeyCode(event, $(this));
    });

    themeEditor.editorZone.on("keyup", ".v-pageContentWidth", function (event) {
        var value = ($(this).val() === "") ? "100%" : $(this).val() + "px";
        $(".pageContentContainer", themeEditor.previewZone).css("width", value);
        themeEditor.saveSetting("pageContentContainer", "width", $(this).val().replace("px", ""));
    });

    themeEditor.editorZone.on("click", ".v-pageSetupCenterQuestions", function () {
        var value = $("input", $(this)).is(":checked");
        $(".pageBackground", themeEditor.previewZone).toggleClass("centerQuestions", value);
        themeEditor.saveThemeValue("CenterQuestions", value.toString());
    });

    themeEditor.editorZone.on("focusout", ".v-customHeader", function (event) {
        themeEditor.saveThemeValue("HEAD", a4.encodeHtml($(this).val()));
    });

    themeEditor.editorZone.on("focusout", ".v-customScript", function (event) {
        themeEditor.saveThemeValue("CustomJavascript", a4.encodeHtml($(this).val()));
    });

    themeEditor.editorZone.on("focusout", ".v-customCss", function (event) {
        themeEditor.saveThemeValue("CustomCSS", a4.encodeHtml($(this).val()));
    });
}

themeEditor.setNavigationButtonChange = function () {
    themeEditor.container.on("change", ".v-navigationButton", function () {
        var value = $(this).val();
        var buttonCssClass = $(this).attr("data-class").toString();
        var displayTop = (value == "Top" || value == "Both") ? "inline-block" : "none";
        var displayBottom = (value == "Bottom" || value == "Both") ? "inline-block" : "none";

        // Change display in preview
        $(".navigationBarTop ." + buttonCssClass, themeEditor.previewZone).css("display", displayTop);
        $(".navigationBarBottom ." + buttonCssClass, themeEditor.previewZone).css("display", displayBottom);

        // Reset the navigation Bars
        //themeEditor.setNavigationBarDisplay($(".navigationBarTop", themeEditor.previewZone));
        //themeEditor.setNavigationBarDisplay($(".navigationBarBottom", themeEditor.previewZone));

        // Save theme properties
        var buttonType = buttonCssClass.replace("navigation", "");
        themeEditor.saveThemeValue(buttonType + "Visible", (value == "None") ? "false" : "true");
        themeEditor.saveThemeValue(buttonType + "DisplayPosition", value);
    });

    themeEditor.container.on("change", ".v-showNavigationBar input:radio", function () {
        var value = $(this).val();
        var navigationBar = themeEditor.activeClass + "Container";

        // Change display in preview
        $("." + navigationBar, themeEditor.previewZone).toggle(value == "show");

        // Save theme properties
        themeEditor.saveThemeValue(themeEditor.activeClass + "Visible", (value == "show") ? "true" : "false");
    });

    themeEditor.container.on("change", ".v-showNavigationButton input:radio", function () {
        var value = $(this).val();
        var buttonCssClass = $(this).attr("data-class").toString();
        var buttonContainerType = $(this).parents(".navigationContainer").attr("data-container").toString();
        var navigationBar = ".navigationBar" + buttonContainerType;

        // Change display in preview
        $(navigationBar + " ." + buttonCssClass, themeEditor.previewZone).toggle(value == "show");

        // Reset the navigation Bar
        themeEditor.setModuleNavigationBarDisplay($(navigationBar, themeEditor.previewZone));

        // Save theme properties
        var buttonType = buttonCssClass.replace("navigation", "");
        themeEditor.saveThemeValue(buttonContainerType + buttonType + "Visible", (value == "show") ? "true" : "false");
    });
}

themeEditor.setModuleNavigationBarDisplay = function (navigationBar) {
    var isBarVisible = false;

    $(".buttonContainer", navigationBar).each(function () {
        if ($(this).css("display") != "none") {
            isBarVisible = true;
            return false;
        }
    });

    navigationBar.toggle(isBarVisible)
}

themeEditor.setProgressBarChangeEvent = function () {
    themeEditor.container.on("change", ".v-progressBarDropdown", function () {
        var value = $(this).val();

        $(".progressBarTop", themeEditor.previewZone).toggle(value == "Top" || value == "Both");
        $(".progressBarBottom", themeEditor.previewZone).toggle(value == "Bottom" || value == "Both");
        $(".progressBarLeft", themeEditor.previewZone).toggle(value == "Left");
        $(".progressBarRight", themeEditor.previewZone).toggle(value == "Right");

        if (themeEditor.isModule)
            $(".v-verticalAlignContainer", $(this).closest(".v-editThemeElement")).toggle(value == "Left" || value == "Right");

        themeEditor.saveThemeValue("ProgressBarVisible", (value == "None") ? "false" : "true");
        themeEditor.saveThemeValue("ProgressBarLocation", value);
    });
}

themeEditor.setLanguageSelectorChangeEvent = function () {
    themeEditor.container.on("change", ".v-languageSelectorDropdown", function () {
        var value = $(this).val();

        $(".languageSelectorTop", themeEditor.previewZone).toggle(value == "Top" || value == "Both");
        $(".languageSelectorBottom", themeEditor.previewZone).toggle(value == "Bottom" || value == "Both");

        themeEditor.saveThemeValue("LanguageSelectorVisible", (value == "None") ? "false" : "true");
        themeEditor.saveThemeValue("LanguageSelectorLocation", value);
    });
}

themeEditor.setElementDisplayLocationChange = function () {
    themeEditor.container.on("change", ".v-elementDisplayLocationDropdown", function () {
        var value = $(this).val();
        var element = $(this).attr("data-element");

        // Toggle containers on value Top or Bottom
        $("." + element + "TopContainer", themeEditor.previewZone).toggle(value == "TopLeft" || value == "TopCenter" || value == "TopRight");
        $("." + element + "BottomContainer", themeEditor.previewZone).toggle(value == "BottomLeft" || value == "BottomCenter" || value == "BottomRight");

        // Replace value to get css property
        var cssValue = value.replace("Bottom", "").replace("Top", "").toLowerCase();
        $("." + element + "Container:visible", themeEditor.previewZone).css("text-align", cssValue);

        themeEditor.saveThemeValue(element + "Visible", (value == "None") ? "false" : "true");

        if (element == "SurveyShortcut")
            themeEditor.saveThemeValue("SurveyShorcutsLocation", value);
        else
            themeEditor.saveThemeValue(element + "Location", value);
    });
}

themeEditor.validateKeyCode = function (_event, element) {
    // Allow only tab, backspace, delete, left and right arrow
    if (_event.keyCode == 38 || _event.keyCode == 40)
    {
        var newValue = parseInt(element.val(), 10) || 0;

        if (_event.keyCode == 38)
            newValue += 1;
        else
            newValue -= 1;

        element.val(newValue > 0 ? newValue : 0);
    }
    else if (_event.keyCode == 9 || _event.keyCode == 46 || _event.keyCode == 8 || _event.keyCode == 37 || _event.keyCode == 39)
    {
        return true;
    }
    else
    {
        // Ensure that it is a number and stop the keypress (0-9 equals keyCode 48 to 57, 96 to 105 are keypad numbers)
        if (_event.keyCode < 48 || (57 < _event.keyCode && _event.keyCode < 96) || 105 < _event.keyCode) {
            _event.preventDefault();
            return false;
        }
    }

    return true;
}

themeEditor.checkAndClearUnspecifiedValue = function (_element) {
    if ($(_element).hasClass("unspecified")) {
        $(_element).removeClass("unspecified");
        $(_element).val("");
    }
}

themeEditor.setPreview = function () {
    themeEditor.setDisableEnterKeyEvent(themeEditor.container);
    $(".choiceTextContainer").show();

    // Set display of question text and name
    themeEditor.applyDisplaySettingsOfQuestions();

    $(".buttonVoxco", themeEditor.container).removeClass("buttonVoxco").button();

    var _alignVal = themeEditor.previewZone.find(".defaultAlign").val();

    // Set the preview zone with the float property (either left or right, otherwise the margin property will do the align center)
    if (_alignVal != "center") {
        $(".previewZoneContainer", themeEditor.container).css("float", _alignVal);
    }

    // Adjust progress bar display if in chrome
    var userAgent = navigator.userAgent.toLowerCase();
    if (/chrome/.test(navigator.userAgent.toLowerCase())) {
        themeEditor.setProgressBarInChrome("progressBarContainer", $(".progressBarContainer", themeEditor.previewZone).css("float"));
    }

    // Set Progress Bar
    if ($(".progressBarShowLabel input").not(":checked").length > 0) {
        $(".progressBarLabel", themeEditor.previewZone).hide();
    }

    if ($(".progressBarShowPercentage input").not(":checked").length > 0) {
        $(".progressBarPercentage", themeEditor.previewZone).hide();
    }

    // Delay until full width of preview is adjusted
    // setTimeout(function () { themeEditor.setRadioAndCheckboxDisplay(themeEditor.previewZone); }, 40);
    themeEditor.setRadioAndCheckboxDisplay(themeEditor.previewZone);

    // show/hide block theme overridden notice
    if ($(".v-selectBlock", themeEditor.container).find(":selected").attr("data-overridden") == "false") {
        $(".override-notice", themeEditor.previewZone).hide();
    }

    themeEditor.setTooltips(themeEditor.tooltipsVisible);
}

themeEditor.setTemplatePreviewZone = function (zone) {
    themeEditor.setRadioAndCheckboxDisplay(zone);
}

themeEditor.setRadioAndCheckboxDisplay = function (panel) {
    // Add image inputs for checkboxes
    var src = themeEditor.checkBoxImage || themeEditor.defaultVoxcoImage;

    if ($(".checkBox input:image", panel).length == 0) {
        $(".checkBox input", panel).each(function () {
            $(this).before("<input type='image' src='" + src + "' style='display:none;' onclick='themeEditor.changeSelectedImage($(this), false);return false;' />");
        });
    }
    else {
        $(".checkBox input:image", panel).attr("src", src);
    }

    // Add image inputs radio buttons
    src = themeEditor.radioButtonImage || themeEditor.defaultVoxcoImage;

    if ($(".radioButton input:image", panel).length == 0) {
        $(".radioButton input", panel).each(function () {
            $(this).before("<input type='image' src='" + src + "' style='display:none;' onclick='themeEditor.changeSelectedImage($(this), true);return false;' />");
        });
    }
    else {
        //$(".radioButton input:image", panel).attr("src", src);
        $(".radioButton input:image:not(.questionClearButton)", panel)
    }

    var showImage = (themeEditor.checkboxType == "Image");
    $(".checkBox input:image", panel).toggle(showImage);
    $(".checkBox input:checkbox", panel).toggle(!showImage);

    showImage = (themeEditor.radioButtonType == "Image");
    $(".radioButton input:image:not(.questionClearButton)", panel).toggle(showImage);
    $(".radioButton input:radio", panel).toggle(!showImage);

    //Set images
    themeEditor.applyChoiceImageBorderChange($(".choiceImage", panel), $("#ChoiceImageCss", themeEditor.previewZone));

    //themeEditor.setModuleImages();
}

themeEditor.applyDisplaySettingsOfQuestions = function () {
    $(".questionNameContainer", themeEditor.previewZone).toggle(themeEditor.questionNameVisible);
    $(".questionTextContainer", themeEditor.previewZone).toggle(themeEditor.questionTextVisible);
}

themeEditor.changeSelectedImage = function (element, isRadio) {
    var choiceList = element.closest(".choiceList");

    var defaultImage = (isRadio ? themeEditor.radioButtonImage : themeEditor.checkBoxImage) || themeEditor.defaultVoxcoImage;
    $("input:image", choiceList).attr("src", defaultImage);
    $("input:image", choiceList).removeClass("selected");

    var selectedImage = (isRadio ? themeEditor.radioButtonSelectedImage : themeEditor.checkBoxSelectedImage) || themeEditor.defaultVoxcoImage;
    element.attr("src", selectedImage);
    element.addClass("selected");
}

themeEditor.setPreviewEvents = function () {
    $(".submitAccordion").on("click", function () {
        if ($(".v-buttonImageSection").is(":visible")) {
            $(".v-submitText").hide();
            $(".v-submitImage").show();
        }
        else {
            $(".v-submitText").show();
            $(".v-submitImage").hide();
        }
    });

    themeEditor.editorZone.on("click", ".interrogation", function () {
        var tooltip = $(".tooltip", $(this).closest(".information"));

        if (tooltip.not(":visible")) {
            var item = $(this).position();
            tooltip.css("left", item.left - 255);
        }

        tooltip.toggle("slow");
    });

    // Choice image events
    themeEditor.previewZone.on("mouseover", '.choiceImage', function () {
        var image = $(this);
        image.addClass("highlightedImageChoice");
        themeEditor.applyChoiceImageBorderChange(image, $("#HighlightedImageCss", themeEditor.previewZone));
    });

    themeEditor.previewZone.on("mouseout", '.choiceImage', function () {
        var image = $(this);
        image.removeClass("highlightedImageChoice");
        image.attr("style", "");
        image.css("margin", "");

        if (image.hasClass("selectedImageChoice"))
            themeEditor.applyChoiceImageBorderChange(image, $("#SelectedImageCss", themeEditor.previewZone));
        else
            themeEditor.applyChoiceImageBorderChange(image, $("#ChoiceImageCss", themeEditor.previewZone));
    });

    themeEditor.previewZone.on("click", '.choiceImage', function () {
        var choiceList = $(this).closest(".choiceList");
        themeEditor.applyChoiceImageBorderChange($(".choiceImage.selectedImageChoice", choiceList), $("#ChoiceImageCss", themeEditor.previewZone));
        $(".choiceImage.selectedImageChoice", choiceList).removeClass("selectedImageChoice");

        $(this).addClass("selectedImageChoice");
        themeEditor.applyChoiceImageBorderChange($(this), $("#SelectedImageCss", themeEditor.previewZone));
    });

    // Image map events
    $(".imageMap", themeEditor.previewZone).each(function () {
        var imageMap = $(this);

        $(imageMap).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var width = $(value.img).width();
                var height = $(value.img).height();

                $(".area", imageMap).each(function () {
                    $(this).width(Math.min($(this).attr("data-width") * width + 2, width));
                    $(this).height(Math.min($(this).attr("data-height") * height + 2, height));
                    $(this).css("left", Math.ceil($(this).attr("data-left") * width));
                    $(this).css("top", Math.ceil($(this).attr("data-top") * height));

                    if (themeEditor.tooltipsVisible == true) {
                        var selectedChoice = $(this).find(".choiceList select option:selected");
                        $(this).attr("title", $.trim(selectedChoice.text()));
                    }
                });
            });
        });
    });

    themeEditor.previewZone.on("mouseover", '.imageMap .area', function () {
        $(this).addClass("highlightedImageArea");
        themeEditor.copyColorChange($(this), $("#HighlightedImageAreaCss", themeEditor.previewZone));
    });

    themeEditor.previewZone.on("mouseout", '.imageMap .area', function () {
        $(this).removeClass("highlightedImageArea");

        if ($(this).hasClass("selectedImageArea")) {
            themeEditor.copyColorChange($(this), $("#SelectedImageAreaCss", themeEditor.previewZone));
        }
        else {
            $(this).css("background-color", "");
        }
    });

    themeEditor.previewZone.on("click", '.imageMap .area', function () {
        if ($(this).hasClass("selectedImageArea")) {
            $(this).removeClass("selectedImageArea");
            $(this).css("background-color", "");
        }
        else {
            $(this).addClass("selectedImageArea");
            themeEditor.copyColorChange($(this), $("#SelectedImageAreaCss", themeEditor.previewZone));
        }
    });

    // Set hover events
    $(".backButton:image", themeEditor.previewZone).on('mouseenter', function () {
        $(this).attr("data-defaultImg", $(this).attr("src"));

        if (themeEditor.backButtonHoverImage != "") {
            $(this).attr("src", themeEditor.backButtonHoverImage);
        }
    }).on('mouseleave', function () {
        $(this).attr("src", $(this).attr("data-defaultImg"));
    });

    $(".nextButton:image", themeEditor.previewZone).on('mouseenter', function () {
        $(this).attr("data-defaultImg", $(this).attr("src"));

        if (themeEditor.nextButtonHoverImage != "") {
            $(this).attr("src", themeEditor.nextButtonHoverImage);
        }
    }).on('mouseleave', function () {
        $(this).attr("src", $(this).attr("data-defaultImg"));
    });

    $(".quitButton:image", themeEditor.previewZone).on('mouseenter', function () {
        $(this).attr("data-defaultImg", $(this).attr("src"));

        if (themeEditor.quitButtonHoverImage != "") {
            $(this).attr("src", themeEditor.quitButtonHoverImage);
        }
    }).on('mouseleave', function () {
        $(this).attr("src", $(this).attr("data-defaultImg"));
    });

    $(".questionClearButton:image", themeEditor.previewZone).on('mouseenter', function () {
        $(this).attr("data-defaultImg", $(this).attr("src"));

        if (themeEditor.questionClearButtonHoverImage == "") {
            if ($(this).attr("data-hoverimg") != "" && $(this).attr("data-hoverimg") != undefined)
                themeEditor.questionClearButtonHoverImage = $(this).attr("data-hoverimg");
        }

        if (themeEditor.questionClearButtonHoverImage != "") {
            $(this).attr("src", themeEditor.questionClearButtonHoverImage);
        }
    }).on('mouseleave', function () {
        $(this).attr("src", $(this).attr("data-defaultImg"));
    });


    themeEditor.previewZone.on("mouseover", ".choiceList div.choice,li.rankingItem", function () {
        if (themeEditor.choiceHoverColor != "") {
            $(this).css("background-color", themeEditor.choiceHoverColor);
        }
    });

    themeEditor.previewZone.on("mouseout", ".choiceList div.choice,li.rankingItem", function () {
        $(this).css("background-color", "inherit");
    });

    // Grid row events
    function addBackgroundColorStyle(elements, cssClass) {
        $(elements).each(function () {
            if (!$(this).hasClass(cssClass)) {
                if (!$(this).attr('data-background-color') && $(this).css('background-color')) {
                    $(this).attr('data-background-color', $(this).css('background-color'));
                }

                $(this).addClass(cssClass);
            }
        });
    }

    function removeBackgroundColorStyle(elements, cssClass) {
        $(elements).each(function () {
            if ($(this).hasClass(cssClass)) {
                $(this).removeClass(cssClass);
                $(this).css('background-color', $(this).attr('data-background-color'));
            }
        });
    }

    function GetAxisElements(cell) {
        var row = cell.closest("tr");

        var elements = $("td.gridItem", row).filter(function (index) {
            var rowspan = $(this).attr("rowspan");
            return rowspan == undefined || rowspan == 1;
        });

        var hasColumn = cell.attr("data-column-position");
        var dataColumnCount = $("td[data-column-position]", row).length;

        if (hasColumn && dataColumnCount > 1) {
            var table = cell.closest("table");
            var columnPosition = cell.attr("data-column-position");
            var choicePosition = cell.attr("data-choice-position");

            if (columnPosition != undefined) {
                var columns;

                if (choicePosition != undefined) {
                    columns = $(".gridItem[data-column-position=" + columnPosition + "][data-choice-position=" + choicePosition + "]", table);
                }
                else {
                    columns = $(".gridItem[data-column-position=" + columnPosition + "]", table);
                }

                elements = elements.add(columns);
            }
        }

        return elements;
    }

    themeEditor.previewZone.on("mousemove", "table.grid.enableAxisHighlighting", function (args) {
        var target = $(args.target).closest("td.gridItem");
        var highlightedElements = $(".gha", this);
        var elementsToHighlight = GetAxisElements(target);
        removeBackgroundColorStyle(highlightedElements.not(elementsToHighlight), "gha");
        addBackgroundColorStyle(elementsToHighlight, "gha");
        themeEditor.fixAxisColors();
    });

    themeEditor.previewZone.on("mouseleave", "table.grid.enableAxisHighlighting", function (args) {
        removeBackgroundColorStyle($(".gha", this), "gha");
        themeEditor.fixAxisColors();
    });

    themeEditor.previewZone.on("click", "table.grid.enableAxisSelection tbody .gridRow td.gridItem, table.grid.enableAxisSelection tbody .gridAlternateRow td.gridItem", function () {
        var grids = $("table.grid", themeEditor.previewZone);
        removeBackgroundColorStyle(grids.find(".gsa"), "gsa");
        addBackgroundColorStyle(GetAxisElements($(this)), "gsa");
        themeEditor.fixAxisColors();
    });
}

themeEditor.applyChoiceImageBorderChange = function (to, src) {
    themeEditor.copyBorderStyleSide(to, src, "border-top-style", "border-top-width", "border-top-color", "top");
    themeEditor.copyBorderStyleSide(to, src, "border-right-style", "border-right-width", "border-right-color", "right");
    themeEditor.copyBorderStyleSide(to, src, "border-bottom-style", "border-bottom-width", "border-bottom-color", "bottom");
    themeEditor.copyBorderStyleSide(to, src, "border-left-style", "border-left-width", "border-left-color", "left");
}

themeEditor.copyBorderStyleSide = function (to, src, styleProp, widthProp, colorProp, side) {
    var srcVal = src.css(styleProp);
    to.css(styleProp, srcVal);
    // $("img", to).css("margin-" + side, "0px");

    if (srcVal != "none") {
        to.css(colorProp, src.css(colorProp));
        to.css(widthProp, src.css(widthProp));
        //$("img", to).css("margin-" + side, "-" + src.css(widthProp));
    }
}

themeEditor.copyColorChange = function (to, src) {
    if (src.css("background-color")) {
        to.css("background-color", src.css("background-color"));
    }
}

themeEditor.fixAxisColors = function () {
    $(".gridItem.gsa", themeEditor.previewZone).each(function () {
        $(this).css('background-color', $(this).attr('data-background-color'));
    });

    if (themeEditor.gridSelectedAxisColor) {
        $(".gridItem.gsa", themeEditor.previewZone).css('background-color', themeEditor.gridSelectedAxisColor);
    }
    else {
        $(".gridItem.gsa", themeEditor.previewZone).each(function () {
            $(this).css('background-color', $(this).attr('data-background-color'));
        });
    }

    if (themeEditor.gridHighlighedAxisColor) {
        $(".gridItem.gha", themeEditor.previewZone).css('background-color', themeEditor.gridHighlighedAxisColor);
    }
    else {
        $(".gridItem.gha:not(.gsa)", themeEditor.previewZone).each(function () {
            $(this).css('background-color', $(this).attr('data-background-color'));
        });
    }
}

themeEditor.setTemplatesClickEvent = function () {
    $(".h-change", themeEditor.context).on("click", function () {
        if ($(".h-saveTemplateSelection", themeEditor.context).is(":visible"))
            return;

        var templatePanel = $(".v-libraryBrowserPanel", themeEditor.container);
        var themeContainer = $("#themeContainer");
        $(".v-leftPanel", themeEditor.container).hide();
        $(".h-saveTemplateSelection", themeEditor.context).css("display", "inline-block");
        $(".h-saveTheme", themeEditor.context).css("display", "none");
        $(".h-libraryActions", themeEditor.context).css("display", "none");
        //$(".h-customize", themeEditor.context).css("display", "block");

        if (templatePanel.html() == "" || libraryBrowser.reloadThemeBrowser) {
            $(".v-mainPanel", themeEditor.container).hide();
            themeEditor.loadTemplatePanel(templatePanel);
            libraryBrowser.reloadThemeBrowser = false;
        }
        else {
            themeEditor.completeLoadTemplatePanel(templatePanel);
        }
    });
}

themeEditor.adjustMainPanel = function (container) {
    $(".v-mainPanel .zoom", container).css("display", "inline-block");
}

themeEditor.loadTemplatePanel = function (templatePanel) {
    a4.callServerMethod(a4.getSurveyAction("GetTemplateBrowserPanel", "LookAndFeel"), {},
        function (result) {
            templatePanel.html(result);
            themeEditor.completeLoadTemplatePanel(templatePanel, InitializeImportQuestions());
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        },
        { blockElement: themeEditor.container }
	);
}

themeEditor.completeLoadTemplatePanel = function (templatePanel, callback) {
    $(".v-contentFrame .v-content", templatePanel).html(themeEditor.previewZone.html());
    templatePanel.show();

    if (callback != undefined)
        callback();

    //themeEditor.adjustThemeSelectionPanels();
    themeEditor.initializeCustomizeDragAndResize(false);
    themeEditor.initializePreviewZoom();
    themeEditor.setSelectedTemplate(themeEditor.themeName);
}

themeEditor.setSelectedTemplate = function (themeName) {
    $(".v-templateBrowser", templatePanel).find(".title label").html(themeName);
    $(".v-templateBrowserItems .v-items .v-templateItem", themeEditor.container).removeClass("selected");
    $(".v-templateBrowserItems .v-items .v-templateItem[data-themename='" + themeName + "']", themeEditor.container).addClass("selected");
}

themeEditor.setNavigationBarDisplay = function (navigationBar) {
    var location = navigationBar.attr("data-location");

    var backEditDisplay = $(".v-navigationButton[data-class='navigationBackButton']", themeEditor.displayZone).val();
    var nextEditDisplay = $(".v-navigationButton[data-class='navigationNextButton']", themeEditor.displayZone).val();
    var quitEditDisplay = $(".v-navigationButton[data-class='navigationQuitButton']", themeEditor.displayZone).val();

    //navigationBar.toggle(backEditDisplay == "Both" || nextEditDisplay == "Both" || quitEditDisplay == "Both"
    //                        || backEditDisplay == location || nextEditDisplay == location || quitEditDisplay == location);
}

themeEditor.setNavigationBarButtonsAlign = function (previewClass, itemValue) {
    var cssProperty = "float";

    if (previewClass == "navigationBackButton") {
        themeEditor.buttonBackPosition = itemValue;
    }
    else if (previewClass == "navigationNextButton") {
        themeEditor.buttonNextPosition = itemValue;
    }
    else if (previewClass == "navigationQuitButton") {
        themeEditor.buttonQuitPosition = itemValue;
    }

    var backButton = $(".navigationBackButton", themeEditor.previewZone);
    var nextButton = $(".navigationNextButton", themeEditor.previewZone);
    var quitButton = $(".navigationQuitButton", themeEditor.previewZone);

    var backButtonFloat = themeEditor.buttonBackPosition;
    var nextButtonFloat = themeEditor.buttonNextPosition;
    var quitButtonFloat = themeEditor.buttonQuitPosition;

    var navigationBar = nextButton.parent(".navigationBar");
    var navigationBarFloat = "none";
    var navigationBarTextAlignt = "center";
    var navigationBarWidth = "100%";

    var helpArrayPositions = [themeEditor.buttonBackPosition, themeEditor.buttonNextPosition];
    var centerPositionCount = 0;
    var rightPositionCount = 0;
    var leftPositionCount = 0;

    if (quitButton.is(":visible"))
        helpArrayPositions.push(themeEditor.buttonQuitPosition);

    if (themeEditor.isModule) {
        backButtonFloat = "none";
        nextButtonFloat = "none";
        quitButtonFloat = "none";
    }
    else {
        for (var i = 0; i < helpArrayPositions.length; i++) {
            if (helpArrayPositions[i] == "none")
                centerPositionCount += 1;

            if (helpArrayPositions[i] == "right")
                rightPositionCount += 1;

            if (helpArrayPositions[i] == "left")
                leftPositionCount += 1;
        }

        if (rightPositionCount > 1) {
            navigationBarTextAlignt = "right";

            if (themeEditor.buttonBackPosition == "right")
                backButtonFloat = "none";

            if (themeEditor.buttonNextPosition == "right")
                nextButtonFloat = "none";

            if (centerPositionCount > 0) {
                navigationBarWidth = "55%";
                navigationBarFloat = "right";

                if (themeEditor.buttonBackPosition == "none")
                    backButtonFloat = "left";

                if (themeEditor.buttonNextPosition == "none")
                    nextButtonFloat = "left";
            }

            if (quitButton.is(":visible")) {
                if (themeEditor.buttonQuitPosition == "none") {
                    quitButton.css(cssProperty, "left");
                    themeEditor.saveSetting("navigationQuitButton", cssProperty, "left");
                }
                else if (themeEditor.buttonQuitPosition == "right") {
                    quitButton.css(cssProperty, "none");
                    themeEditor.saveSetting("navigationQuitButton", cssProperty, "none");
                }
                else {
                    quitButton.css(cssProperty, "left");
                    themeEditor.saveSetting("navigationQuitButton", cssProperty, "left");
                }
            }
        }
        else {
            quitButton.css(cssProperty, quitButtonFloat);
            themeEditor.saveSetting("navigationQuitButton", cssProperty, quitButtonFloat);
        }

        // save navigation bar settings
        themeEditor.saveSetting("navigationBar", "width", navigationBarWidth);
        themeEditor.saveSetting("navigationBar", "text-align", navigationBarTextAlignt);
        themeEditor.saveSetting("navigationBar", "float", navigationBarFloat);

        // save buttons positions settings
        themeEditor.saveSetting("navigationBackButton", cssProperty, backButtonFloat);
        themeEditor.saveSetting("navigationNextButton", cssProperty, nextButtonFloat);
    }

    // set buttons positions
    backButton.css(cssProperty, backButtonFloat);
    nextButton.css(cssProperty, nextButtonFloat);

    // set navigation bar css properties
    navigationBar.css("text-align", navigationBarTextAlignt).css("float", navigationBarFloat).css("width", navigationBarWidth);
}

///////////////////////////////////////////////////
// Templates
///////////////////////////////////////////////////

themeEditor.setSaveTemplateSelectionEvent = function () {   
    themeEditor.context.on("click", ".h-saveTemplateSelection", function () {
        themeEditor.saveTheme(true, false);
    });
}

themeEditor.setCancelCustomizationSelectionEvent = function () {
    themeEditor.context.on("click", ".h-cancelCustomizeButton", function () {
        location.reload();
    });
}

themeEditor.loadCustomizeTemplateSelection = function () {
    $(".v-mainPanel", themeEditor.container).hide();
    $(".h-saveTemplateSelection", themeEditor.context).css("display", "none");
    $(".h-saveTheme", themeEditor.context).css("display", "inline-block");
    $(".h-libraryActions", themeEditor.context).css("display", "inline-block");

    themeEditor.resetPageModification();
    themeEditor.switchToEditThemeMode();
}

themeEditor.setSaveToLibraryEvent = function () {
    themeEditor.context.on("click", ".h-saveToLibrary", function () {
        modalDialog.showWindow(a4.getAction("AddThemeToLibrary", "SurveyTemplates", "Library", { themeId: themeEditor.themeId, useS2: false }), 270, 650);
    });
}

themeEditor.saveToLibraryComplete = function (categoryId) {
    var libraryPanel = $(".v-libraryBrowserPanel", themeEditor.container);

    if (libraryPanel.html() != "" && $("#category" + categoryId, libraryPanel).length == 0)
        libraryPanel.html("");
}

themeEditor.switchToEditThemeMode = function () {
    $(".v-libraryBrowserPanel", themeEditor.container).hide();

    $(".v-mainPanel", themeEditor.container).show();
    $(".v-leftPanel", themeEditor.container).show();
    themeEditor.adjustMainPanel(themeEditor.container);

    $('html, body').animate({
        scrollTop: 0
    }, 400, "swing", function () {
        // themeEditor.resetPreviewTitleFloat();
        // themeEditor.initializeCustomizationPanel(themeEditor.editorZone);
    });
}

themeEditor.setDisableEnterKeyEvent = function (panel) {
    $(":input:not(textarea)", panel).on("keypress", function (e) {
        return e.keyCode != 13;
    });
}

themeEditor.disableItems = function () {
    $("select:not(.editItemsDropdown), input", themeEditor.editorZone).prop("disabled", true).addClass("inactive").on("click", function () { return false; });
}

themeEditor.applySecurity = function () {
    if (themeEditor.isReadOnly) {
        themeEditor.disableItems();
        $(".saveTheme").prop("disabled", true).hide();
    }
}

themeEditor.adjustNumericRankingTextWidth = function () {
    $(".numericRanking", themeEditor.previewZone).each(function () {
        var control = $(this);
        var textWidth = 0;

        if ($(".numericRanking", control).hasClass("left")) {
            $(".numericRanking.left li.rankingItem", control).each(function () {
                var textDiv = $(this).find(".textDiv");

                if (textDiv.width() > textWidth)
                    textWidth = textDiv.width();
            });

            if (textWidth > 0)
                $(".numericOptionsList li.rankingItem > .textDiv", control).width(textWidth);
        }
        else {
            var headerWidth = $(".numericRanking li.header", control).find(".textDiv").width();
            var inputDivWidth = $(".numericRanking li.rankingItem", control).find(".inputDiv:first").width();

            if (headerWidth > inputDivWidth)
                $(".numericOptionsList li.rankingItem > .inputDiv", control).width(headerWidth);
        }
    });
}

themeEditor.executeHorizontalPositionChange = function (themeElementType) {
    $("." + themeElementType, themeEditor.previewZone).css("text-align", themeEditor.editorItemValue);
}